/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.report.projectinfo.dependencies;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.dependency.graph.DependencyNode;
import org.apache.maven.shared.jar.JarAnalyzer;
import org.apache.maven.shared.jar.JarData;
import org.apache.maven.shared.jar.classes.JarClasses;
import org.apache.maven.shared.jar.classes.JarClassesAnalysis;
import org.codehaus.plexus.util.StringUtils;

public class Dependencies {
    private final MavenProject project;
    private final DependencyNode dependencyNode;
    private final JarClassesAnalysis classesAnalyzer;
    private List<Artifact> projectDependencies;
    private List<Artifact> projectTransitiveDependencies;
    private List<Artifact> allDependencies;
    private Map<String, List<Artifact>> dependenciesByScope;
    private Map<String, List<Artifact>> transitiveDependenciesByScope;
    private Map<String, JarData> dependencyDetails;

    public Dependencies(MavenProject project, DependencyNode dependencyTreeNode, JarClassesAnalysis classesAnalyzer) {
        this.project = project;
        this.dependencyNode = dependencyTreeNode;
        this.classesAnalyzer = classesAnalyzer;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public boolean hasDependencies() {
        return this.getProjectDependencies() != null && !this.getProjectDependencies().isEmpty();
    }

    public List<Artifact> getProjectDependencies() {
        if (this.projectDependencies != null) {
            return this.projectDependencies;
        }
        this.projectDependencies = new ArrayList<Artifact>();
        for (DependencyNode dep : this.dependencyNode.getChildren()) {
            this.projectDependencies.add(dep.getArtifact());
        }
        return this.projectDependencies;
    }

    public List<Artifact> getTransitiveDependencies() {
        if (this.projectTransitiveDependencies != null) {
            return this.projectTransitiveDependencies;
        }
        this.projectTransitiveDependencies = new ArrayList<Artifact>(this.getAllDependencies());
        this.projectTransitiveDependencies.removeAll(this.getProjectDependencies());
        return this.projectTransitiveDependencies;
    }

    public List<Artifact> getAllDependencies() {
        if (this.allDependencies != null) {
            return this.allDependencies;
        }
        this.allDependencies = new ArrayList<Artifact>();
        this.addAllChildrenDependencies(this.dependencyNode);
        return this.allDependencies;
    }

    public Map<String, List<Artifact>> getDependenciesByScope(boolean isTransitively) {
        if (isTransitively) {
            if (this.transitiveDependenciesByScope != null) {
                return this.transitiveDependenciesByScope;
            }
            this.transitiveDependenciesByScope = new HashMap<String, List<Artifact>>();
            for (Artifact artifact : this.getTransitiveDependencies()) {
                List<Artifact> multiValue = this.transitiveDependenciesByScope.get(artifact.getScope());
                if (multiValue == null) {
                    multiValue = new ArrayList<Artifact>();
                }
                if (!multiValue.contains(artifact)) {
                    multiValue.add(artifact);
                }
                this.transitiveDependenciesByScope.put(artifact.getScope(), multiValue);
            }
            return this.transitiveDependenciesByScope;
        }
        if (this.dependenciesByScope != null) {
            return this.dependenciesByScope;
        }
        this.dependenciesByScope = new HashMap<String, List<Artifact>>();
        for (Artifact artifact : this.getProjectDependencies()) {
            List<Artifact> multiValue = this.dependenciesByScope.get(artifact.getScope());
            if (multiValue == null) {
                multiValue = new ArrayList<Artifact>();
            }
            if (!multiValue.contains(artifact)) {
                multiValue.add(artifact);
            }
            this.dependenciesByScope.put(artifact.getScope(), multiValue);
        }
        return this.dependenciesByScope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JarData getJarDependencyDetails(Artifact artifact) throws IOException {
        JarData jarData;
        if (this.dependencyDetails == null) {
            this.dependencyDetails = new HashMap<String, JarData>();
        }
        if ((jarData = this.dependencyDetails.get(artifact.getId())) != null) {
            return jarData;
        }
        File file = this.getFile(artifact);
        if (file.isDirectory()) {
            jarData = new JarData(artifact.getFile(), null, new ArrayList());
            jarData.setJarClasses(new JarClasses());
        } else {
            JarAnalyzer jarAnalyzer = new JarAnalyzer(file);
            try {
                this.classesAnalyzer.analyze(jarAnalyzer);
            }
            finally {
                jarAnalyzer.closeQuietly();
            }
            jarData = jarAnalyzer.getJarData();
        }
        this.dependencyDetails.put(artifact.getId(), jarData);
        return jarData;
    }

    private void addAllChildrenDependencies(DependencyNode dependencyNode) {
        for (DependencyNode subdependencyNode : dependencyNode.getChildren()) {
            Artifact artifact = subdependencyNode.getArtifact();
            if (artifact.getGroupId().equals(this.project.getGroupId()) && artifact.getArtifactId().equals(this.project.getArtifactId()) && artifact.getVersion().equals(this.project.getVersion())) continue;
            if (!this.allDependencies.contains(artifact)) {
                this.allDependencies.add(artifact);
            }
            this.addAllChildrenDependencies(subdependencyNode);
        }
    }

    public File getFile(Artifact artifact) {
        File file = artifact.getFile();
        if (file.isDirectory()) {
            String filename = artifact.getArtifactId() + '-' + artifact.getVersion();
            if (StringUtils.isNotEmpty((String)artifact.getClassifier())) {
                filename = filename + '-' + artifact.getClassifier();
            }
            filename = filename + '.' + artifact.getType();
            File jar = new File(file, "../" + filename);
            if (jar.exists()) {
                return jar;
            }
        }
        return file;
    }
}

