/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol;

import com.hazelcast.internal.networking.OutboundFrame;
import com.hazelcast.internal.nio.Bits;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.internal.tpcengine.net.AsyncSocket;
import java.util.Arrays;
import java.util.Objects;

public final class ClientMessage
implements OutboundFrame {
    public static final int TYPE_FIELD_OFFSET = 0;
    public static final int CORRELATION_ID_FIELD_OFFSET = 4;
    public static final int RESPONSE_BACKUP_ACKS_FIELD_OFFSET = 12;
    public static final int PARTITION_ID_FIELD_OFFSET = 12;
    public static final int FRAGMENTATION_ID_OFFSET = 0;
    public static final int DEFAULT_FLAGS = 0;
    public static final int BEGIN_FRAGMENT_FLAG = 32768;
    public static final int END_FRAGMENT_FLAG = 16384;
    public static final int UNFRAGMENTED_MESSAGE = 49152;
    public static final int IS_FINAL_FLAG = 8192;
    public static final int BEGIN_DATA_STRUCTURE_FLAG = 4096;
    public static final int END_DATA_STRUCTURE_FLAG = 2048;
    public static final int IS_NULL_FLAG = 1024;
    public static final int IS_EVENT_FLAG = 512;
    public static final int BACKUP_AWARE_FLAG = 256;
    public static final int BACKUP_EVENT_FLAG = 128;
    public static final int SIZE_OF_FRAME_LENGTH_AND_FLAGS = 6;
    public static final Frame NULL_FRAME = new Frame(new byte[0], 1024);
    public static final Frame BEGIN_FRAME = new Frame(new byte[0], 4096);
    public static final Frame END_FRAME = new Frame(new byte[0], 2048);
    private static final long serialVersionUID = 1L;
    private transient Frame startFrame;
    private Frame endFrame;
    private transient boolean isRetryable;
    private transient String operationName;
    private transient Connection connection;
    private transient boolean containsSerializedDataInRequest;
    private AsyncSocket asyncSocket;

    private ClientMessage() {
    }

    private ClientMessage(Frame startFrame) {
        assert (startFrame.next == null);
        this.startFrame = startFrame;
        this.endFrame = startFrame;
    }

    public ClientMessage(Frame startFrame, Frame endFrame) {
        this.startFrame = startFrame;
        this.endFrame = endFrame;
    }

    public static ClientMessage createForEncode() {
        return new ClientMessage();
    }

    public static ClientMessage createForDecode(Frame startFrame) {
        return new ClientMessage(startFrame);
    }

    public Frame getStartFrame() {
        return this.startFrame;
    }

    public Frame getEndFrame() {
        return this.endFrame;
    }

    public ClientMessage add(Frame frame) {
        frame.next = null;
        if (this.startFrame == null) {
            this.startFrame = frame;
            this.endFrame = frame;
            return this;
        }
        this.endFrame.next = frame;
        this.endFrame = frame;
        return this;
    }

    public ForwardFrameIterator frameIterator() {
        return new ForwardFrameIterator(this.startFrame);
    }

    public int getMessageType() {
        return Bits.readIntL(this.startFrame.content, 0);
    }

    public ClientMessage setMessageType(int messageType) {
        Bits.writeIntL(this.startFrame.content, 0, messageType);
        return this;
    }

    public long getCorrelationId() {
        return Bits.readLongL(this.startFrame.content, 4);
    }

    public ClientMessage setCorrelationId(long correlationId) {
        Bits.writeLongL(this.startFrame.content, 4, correlationId);
        return this;
    }

    public byte getNumberOfBackupAcks() {
        return this.getStartFrame().content[12];
    }

    public ClientMessage setNumberOfBackupAcks(byte numberOfAcks) {
        this.getStartFrame().content[12] = numberOfAcks;
        return this;
    }

    public int getPartitionId() {
        return Bits.readIntL(this.startFrame.content, 12);
    }

    public ClientMessage setPartitionId(int partitionId) {
        Bits.writeIntL(this.startFrame.content, 12, partitionId);
        return this;
    }

    public int getHeaderFlags() {
        return this.startFrame.flags;
    }

    public boolean isRetryable() {
        return this.isRetryable;
    }

    public void setRetryable(boolean isRetryable) {
        this.isRetryable = isRetryable;
    }

    public void setOperationName(String operationName) {
        this.operationName = operationName;
    }

    public String getOperationName() {
        return this.operationName;
    }

    public static boolean isFlagSet(int flags, int flagMask) {
        int i2 = flags & flagMask;
        return i2 == flagMask;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public void setAsyncSocket(AsyncSocket asyncSocket) {
        this.asyncSocket = asyncSocket;
    }

    public AsyncSocket getAsyncSocket() {
        return this.asyncSocket;
    }

    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public int getFrameLength() {
        int frameLength = 0;
        Frame currentFrame = this.startFrame;
        while (currentFrame != null) {
            frameLength += currentFrame.getSize();
            currentFrame = currentFrame.next;
        }
        return frameLength;
    }

    public int getBufferLength() {
        int length = 0;
        Frame currentFrame = this.startFrame;
        while (currentFrame != null) {
            length += currentFrame.content.length + 6;
            currentFrame = currentFrame.next;
        }
        return length;
    }

    @Override
    public boolean isUrgent() {
        return false;
    }

    public void merge(ClientMessage fragment) {
        this.endFrame.next = fragment.startFrame;
        this.endFrame = fragment.endFrame;
    }

    public void dropFragmentationFrame() {
        this.startFrame = this.startFrame.next;
    }

    public boolean isContainsSerializedDataInRequest() {
        return this.containsSerializedDataInRequest;
    }

    public void setContainsSerializedDataInRequest(boolean containsSerializedDataInRequest) {
        this.containsSerializedDataInRequest = containsSerializedDataInRequest;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ClientMessage{");
        sb.append("connection=").append(this.connection);
        if (this.startFrame != null) {
            sb.append(", length=").append(this.getFrameLength());
            sb.append(", operation=").append(this.getOperationName());
            sb.append(", isRetryable=").append(this.isRetryable());
            boolean beginFragment = ClientMessage.isFlagSet(this.startFrame.flags, 32768);
            boolean unFragmented = ClientMessage.isFlagSet(this.startFrame.flags, 49152);
            if (unFragmented) {
                sb.append(", correlationId=").append(this.getCorrelationId());
                sb.append(", messageType=").append(Integer.toHexString(this.getMessageType()));
                sb.append(", isEvent=").append(ClientMessage.isFlagSet(this.startFrame.flags, 512));
            } else if (beginFragment) {
                Frame messageFirstFrame = this.startFrame.next;
                sb.append(", fragmentationId=").append(Bits.readLongL(this.startFrame.content, 0));
                sb.append(", correlationId=").append(Bits.readLongL(messageFirstFrame.content, 4));
                sb.append(", messageType=").append(Integer.toHexString(Bits.readIntL(messageFirstFrame.content, 0)));
                sb.append(", isEvent=").append(ClientMessage.isFlagSet(messageFirstFrame.flags, 512));
            } else {
                sb.append(", fragmentationId=").append(Bits.readLongL(this.startFrame.content, 0));
            }
            sb.append(", isfragmented=").append(!unFragmented);
        }
        sb.append('}');
        return sb.toString();
    }

    public ClientMessage copyWithNewCorrelationId(long correlationId) {
        Frame initialFrameCopy = this.startFrame.deepCopy();
        ClientMessage newMessage = new ClientMessage(initialFrameCopy, this.endFrame);
        newMessage.setCorrelationId(correlationId);
        newMessage.isRetryable = this.isRetryable;
        newMessage.operationName = this.operationName;
        newMessage.containsSerializedDataInRequest = this.containsSerializedDataInRequest;
        return newMessage;
    }

    public ClientMessage copyMessageWithSharedNonInitialFrames() {
        Frame initialFrameCopy = this.startFrame.deepCopy();
        ClientMessage newMessage = new ClientMessage(initialFrameCopy, this.endFrame);
        newMessage.isRetryable = this.isRetryable;
        newMessage.operationName = this.operationName;
        newMessage.containsSerializedDataInRequest = this.containsSerializedDataInRequest;
        return newMessage;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ClientMessage message = (ClientMessage)o;
        if (this.isRetryable != message.isRetryable) {
            return false;
        }
        if (this.containsSerializedDataInRequest != message.containsSerializedDataInRequest) {
            return false;
        }
        if (!Objects.equals(this.operationName, message.operationName)) {
            return false;
        }
        return Objects.equals(this.connection, message.connection);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.isRetryable ? 1 : 0);
        result = 31 * result + (this.containsSerializedDataInRequest ? 1 : 0);
        result = 31 * result + (this.operationName != null ? this.operationName.hashCode() : 0);
        result = 31 * result + (this.connection != null ? this.connection.hashCode() : 0);
        return result;
    }

    public static class Frame {
        public final byte[] content;
        public int flags;
        public Frame next;

        public Frame(byte[] content) {
            this(content, 0);
        }

        public Frame(byte[] content, int flags) {
            assert (content != null);
            this.content = content;
            this.flags = flags;
        }

        public Frame copy() {
            Frame frame = new Frame(this.content, this.flags);
            frame.next = this.next;
            return frame;
        }

        public Frame deepCopy() {
            byte[] newContent = Arrays.copyOf(this.content, this.content.length);
            Frame frame = new Frame(newContent, this.flags);
            frame.next = this.next;
            return frame;
        }

        public boolean isEndFrame() {
            return ClientMessage.isFlagSet(this.flags, 2048);
        }

        public boolean isBeginFrame() {
            return ClientMessage.isFlagSet(this.flags, 4096);
        }

        public boolean isNullFrame() {
            return ClientMessage.isFlagSet(this.flags, 1024);
        }

        public int getSize() {
            return 6 + this.content.length;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Frame frame = (Frame)o;
            if (this.flags != frame.flags) {
                return false;
            }
            return Arrays.equals(this.content, frame.content);
        }

        public int hashCode() {
            int result = Arrays.hashCode(this.content);
            result = 31 * result + this.flags;
            return result;
        }
    }

    public static final class ForwardFrameIterator {
        private Frame nextFrame;

        private ForwardFrameIterator(Frame start) {
            this.nextFrame = start;
        }

        public Frame next() {
            Frame result = this.nextFrame;
            if (this.nextFrame != null) {
                this.nextFrame = this.nextFrame.next;
            }
            return result;
        }

        public boolean hasNext() {
            return this.nextFrame != null;
        }

        public Frame peekNext() {
            return this.nextFrame;
        }
    }
}

