/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.util;

import com.hazelcast.client.impl.connection.Addresses;
import com.hazelcast.client.impl.management.ClientConnectionProcessListenerRegistry;
import com.hazelcast.cluster.Address;
import com.hazelcast.internal.util.AddressUtil;
import com.hazelcast.logging.Logger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public final class AddressHelper {
    private static final int MAX_PORT_TRIES = 3;
    private static final int INITIAL_FIRST_PORT = 5701;

    private AddressHelper() {
    }

    public static String getScopedHostName(AddressUtil.AddressHolder addressHolder) {
        return addressHolder.getScopeId() != null ? addressHolder.getAddress() + "%" + addressHolder.getScopeId() : addressHolder.getAddress();
    }

    public static Addresses getSocketAddresses(String address, ClientConnectionProcessListenerRegistry listenerRunner) {
        AddressUtil.AddressHolder addressHolder = AddressUtil.getAddressHolder(address, -1);
        String scopedAddress = AddressHelper.getScopedHostName(addressHolder);
        int port = addressHolder.getPort();
        int maxPortTryCount = 1;
        if (port == -1) {
            maxPortTryCount = 3;
        }
        return AddressHelper.getPossibleSocketAddresses(port, scopedAddress, maxPortTryCount, listenerRunner);
    }

    public static Addresses getPossibleSocketAddresses(int port, String scopedAddress, int portTryCount, ClientConnectionProcessListenerRegistry listenerRunner) {
        LinkedList<Address> addressList;
        block10: {
            int possiblePort;
            InetAddress inetAddress;
            block11: {
                block9: {
                    inetAddress = null;
                    try {
                        inetAddress = InetAddress.getByName(scopedAddress);
                    }
                    catch (UnknownHostException ignored) {
                        Logger.getLogger(AddressHelper.class).finest("Address not available", ignored);
                    }
                    possiblePort = port;
                    if (possiblePort == -1) {
                        possiblePort = 5701;
                    }
                    addressList = new LinkedList<Address>();
                    if (inetAddress != null) break block9;
                    for (int i2 = 0; i2 < portTryCount; ++i2) {
                        try {
                            addressList.add(new Address(scopedAddress, possiblePort + i2));
                            continue;
                        }
                        catch (UnknownHostException ignored) {
                            listenerRunner.onHostNotFound(scopedAddress);
                            Logger.getLogger(AddressHelper.class).finest("Address not available", ignored);
                        }
                    }
                    break block10;
                }
                if (!(inetAddress instanceof Inet4Address)) break block11;
                for (int i3 = 0; i3 < portTryCount; ++i3) {
                    addressList.add(new Address(scopedAddress, inetAddress, possiblePort + i3));
                }
                break block10;
            }
            if (!(inetAddress instanceof Inet6Address)) break block10;
            Inet6Address address = (Inet6Address)inetAddress;
            Collection<Inet6Address> possibleInetAddresses = AddressUtil.getPossibleInetAddressesFor(address);
            for (Inet6Address inet6Address : possibleInetAddresses) {
                for (int i4 = 0; i4 < portTryCount; ++i4) {
                    addressList.add(new Address(scopedAddress, inet6Address, possiblePort + i4));
                }
            }
        }
        return AddressHelper.toAddresses(addressList);
    }

    private static Addresses toAddresses(List<Address> addressList) {
        Addresses result = new Addresses();
        if (!addressList.isEmpty()) {
            result.primary().add(addressList.remove(0));
            result.secondary().addAll(addressList);
        }
        return result;
    }
}

