/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.cluster.impl;

import com.hazelcast.cluster.Address;
import com.hazelcast.cluster.impl.MemberImpl;
import com.hazelcast.instance.EndpointQualifier;
import com.hazelcast.instance.ProtocolType;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.cluster.impl.TcpIpJoiner;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.internal.util.concurrent.BackoffIdleStrategy;
import com.hazelcast.internal.util.concurrent.IdleStrategy;
import com.hazelcast.spi.discovery.DiscoveryNode;
import com.hazelcast.spi.discovery.integration.DiscoveryService;
import com.hazelcast.spi.properties.ClusterProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class DiscoveryJoiner
extends TcpIpJoiner {
    static final String DISCOVERY_PUBLIC_ADDRESS_FALLBACK_PROPERTY = "hazelcast.discovery.public.address.fallback";
    private final boolean discoveryPublicAddressFallback;
    private final DiscoveryService discoveryService;
    private final boolean usePublicAddress;
    private final IdleStrategy idleStrategy = new BackoffIdleStrategy(0L, 0L, TimeUnit.MILLISECONDS.toNanos(10L), TimeUnit.MILLISECONDS.toNanos(500L));
    private final int maximumWaitingTimeBeforeJoinSeconds;

    public DiscoveryJoiner(Node node, DiscoveryService discoveryService, boolean usePublicAddress) {
        super(node);
        this.maximumWaitingTimeBeforeJoinSeconds = node.getProperties().getInteger(ClusterProperty.WAIT_SECONDS_BEFORE_JOIN);
        this.discoveryService = discoveryService;
        this.usePublicAddress = usePublicAddress;
        this.discoveryPublicAddressFallback = Boolean.getBoolean(DISCOVERY_PUBLIC_ADDRESS_FALLBACK_PROPERTY);
    }

    @Override
    protected Collection<Address> getPossibleAddressesForInitialJoin() {
        Collection<Address> possibleAddresses = null;
        long deadLine = System.nanoTime() + TimeUnit.SECONDS.toNanos(this.maximumWaitingTimeBeforeJoinSeconds);
        int i2 = 0;
        while (System.nanoTime() < deadLine) {
            possibleAddresses = this.getPossibleAddresses();
            if (!possibleAddresses.isEmpty()) {
                return possibleAddresses;
            }
            this.idleStrategy.idle(i2);
            ++i2;
        }
        return possibleAddresses == null ? this.getPossibleAddresses() : possibleAddresses;
    }

    @Override
    protected Collection<Address> getPossibleAddresses() {
        Iterable<DiscoveryNode> discoveredNodes = Preconditions.checkNotNull(this.discoveryService.discoverNodes(), "Discovered nodes cannot be null!");
        MemberImpl localMember = this.node.nodeEngine.getLocalMember();
        Set<Address> localAddresses = this.node.getLocalAddressRegistry().getLocalAddresses();
        ArrayList<Address> possibleMembers = new ArrayList<Address>();
        for (DiscoveryNode discoveryNode : discoveredNodes) {
            Address discoveredAddress;
            Address address = discoveredAddress = this.usePublicAddress ? discoveryNode.getPublicAddress() : discoveryNode.getPrivateAddress();
            if (localAddresses.contains(discoveredAddress)) {
                if (this.usePublicAddress || discoveryNode.getPublicAddress() == null) continue;
                localMember.getAddressMap().put(EndpointQualifier.resolve(ProtocolType.CLIENT, "public"), this.publicAddress(localMember, discoveryNode));
                continue;
            }
            possibleMembers.add(discoveredAddress);
        }
        return possibleMembers;
    }

    private Address publicAddress(MemberImpl localMember, DiscoveryNode discoveryNode) {
        if (this.discoveryPublicAddressFallback && localMember.getAddressMap().containsKey(EndpointQualifier.CLIENT)) {
            try {
                String publicHost = discoveryNode.getPublicAddress().getHost();
                int clientPort = localMember.getAddressMap().get(EndpointQualifier.CLIENT).getPort();
                return new Address(publicHost, clientPort);
            }
            catch (Exception e) {
                this.logger.fine(e);
            }
        }
        return discoveryNode.getPublicAddress();
    }
}

