/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.metrics.impl;

import com.hazelcast.internal.metrics.impl.DefaultMetricDescriptorSupplier;
import com.hazelcast.internal.metrics.impl.MetricDescriptorImpl;
import com.hazelcast.internal.metrics.impl.MetricDescriptorReusableData;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;

class PoolingMetricDescriptorSupplier
implements Supplier<MetricDescriptorImpl> {
    static final int INITIAL_CAPACITY = 32;
    private static final int LAST_SIZE_INCREMENT = 8;
    private static final double GROW_FACTOR = 1.2;
    private final List<MetricDescriptorImpl> allCreated;
    private MetricDescriptorImpl[] pool = new MetricDescriptorImpl[32];
    private int poolPtr;
    private boolean closed;

    PoolingMetricDescriptorSupplier() {
        this.allCreated = new ArrayList<MetricDescriptorImpl>(32);
        for (int i2 = 0; i2 < this.pool.length; ++i2) {
            MetricDescriptorImpl descriptor;
            this.pool[i2] = descriptor = new MetricDescriptorImpl(this);
            this.allCreated.add(descriptor);
        }
        this.poolPtr = this.pool.length - 1;
    }

    PoolingMetricDescriptorSupplier(MetricDescriptorReusableData reusableData) {
        this.allCreated = new ArrayList<MetricDescriptorImpl>(reusableData.getAllCreatedLastSize() + 8);
        this.pool = reusableData.getPool();
        this.poolPtr = reusableData.getPoolPtr();
        for (int i2 = 0; i2 <= this.poolPtr; ++i2) {
            this.pool[i2].setSupplier(this);
            this.allCreated.add(this.pool[i2]);
        }
    }

    @Override
    public MetricDescriptorImpl get() {
        if (this.closed) {
            throw new IllegalStateException("This PoolingMetricDescriptorSupplier is already closed and cannot supply");
        }
        if (this.poolPtr >= 0) {
            MetricDescriptorImpl descriptor = this.pool[this.poolPtr];
            this.pool[this.poolPtr--] = null;
            descriptor.reset();
            return descriptor;
        }
        MetricDescriptorImpl descriptor = new MetricDescriptorImpl(this);
        this.allCreated.add(descriptor);
        return descriptor;
    }

    void recycle(MetricDescriptorImpl descriptor) {
        this.ensureCapacity(this.poolPtr + 1);
        this.pool[++this.poolPtr] = descriptor;
    }

    MetricDescriptorReusableData close() {
        this.closed = true;
        for (MetricDescriptorImpl descriptor : this.allCreated) {
            descriptor.setSupplier(DefaultMetricDescriptorSupplier.DEFAULT_DESCRIPTOR_SUPPLIER);
        }
        int allCreatedLastSize = this.allCreated.size();
        this.allCreated.clear();
        return new MetricDescriptorReusableData(allCreatedLastSize, this.pool, this.poolPtr);
    }

    private void ensureCapacity(int poolPtr) {
        if (poolPtr < this.pool.length - 1) {
            return;
        }
        int newCapacity = (int)Math.ceil((double)poolPtr * 1.2);
        MetricDescriptorImpl[] newPool = new MetricDescriptorImpl[newCapacity];
        System.arraycopy(this.pool, 0, newPool, 0, this.pool.length);
        this.pool = newPool;
    }
}

