/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.partition.impl;

import com.hazelcast.internal.partition.AbstractInternalPartition;
import com.hazelcast.internal.partition.InternalPartition;
import com.hazelcast.internal.partition.PartitionReplica;
import com.hazelcast.internal.partition.PartitionReplicaInterceptor;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Arrays;

public class InternalPartitionImpl
extends AbstractInternalPartition
implements InternalPartition {
    @SuppressFBWarnings(value={"VO_VOLATILE_REFERENCE_TO_ARRAY"}, justification="The contents of this array will never be updated, so it can be safely read using a volatile read. Writing to `replicas` is done under InternalPartitionServiceImpl.lock, so there's no need to guard `replicas` field or to use a CAS.")
    private volatile PartitionReplica[] replicas = new PartitionReplica[7];
    private final PartitionReplicaInterceptor interceptor;
    private volatile int version;
    private volatile PartitionReplica localReplica;
    private volatile boolean isMigrating;

    InternalPartitionImpl(int partitionId, PartitionReplica localReplica, PartitionReplicaInterceptor interceptor) {
        super(partitionId);
        this.localReplica = localReplica;
        this.interceptor = interceptor;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public InternalPartitionImpl(int partitionId, PartitionReplica localReplica, PartitionReplica[] replicas, int version, PartitionReplicaInterceptor interceptor) {
        this(partitionId, localReplica, interceptor);
        this.replicas = replicas;
        this.version = version;
    }

    @Override
    public boolean isMigrating() {
        return this.isMigrating;
    }

    public boolean setMigrating() {
        if (this.isMigrating) {
            return false;
        }
        this.isMigrating = true;
        return true;
    }

    public void resetMigrating() {
        this.isMigrating = false;
    }

    @Override
    public boolean isLocal() {
        PartitionReplica local = this.localReplica;
        return local != null && local.equals(this.getOwnerReplicaOrNull());
    }

    @Override
    public int version() {
        return this.version;
    }

    @Override
    public PartitionReplica getReplica(int replicaIndex) {
        return this.replicas[replicaIndex];
    }

    void swapReplicas(int index1, int index2) {
        PartitionReplica a2;
        PartitionReplica[] newReplicas = Arrays.copyOf(this.replicas, 7);
        PartitionReplica a1 = newReplicas[index1];
        newReplicas[index1] = a2 = newReplicas[index2];
        newReplicas[index2] = a1;
        this.replicas = newReplicas;
        this.onReplicaChange(index1, a1, a2);
        this.onReplicaChange(index2, a2, a1);
    }

    boolean setReplicasAndVersion(InternalPartition partition) {
        boolean ownerChanged = this.setReplicas(partition.getReplicasCopy(), false);
        this.version = partition.version();
        return ownerChanged;
    }

    void setVersion(int version) {
        this.version = version;
    }

    void setReplicas(PartitionReplica[] newReplicas) {
        PartitionReplica[] oldReplicas = this.replicas;
        this.replicas = newReplicas;
        this.onReplicasChange(newReplicas, oldReplicas);
    }

    boolean setReplicas(PartitionReplica[] newReplicas, boolean invokeInterceptor) {
        PartitionReplica[] oldReplicas = this.replicas;
        this.replicas = newReplicas;
        return this.onReplicasChange(newReplicas, oldReplicas, invokeInterceptor);
    }

    void setReplica(int replicaIndex, PartitionReplica newReplica) {
        PartitionReplica[] newReplicas = Arrays.copyOf(this.replicas, 7);
        PartitionReplica oldReplica = newReplicas[replicaIndex];
        newReplicas[replicaIndex] = newReplica;
        this.replicas = newReplicas;
        this.onReplicaChange(replicaIndex, oldReplica, newReplica);
    }

    private boolean onReplicasChange(PartitionReplica[] newReplicas, PartitionReplica[] oldReplicas) {
        return this.onReplicasChange(newReplicas, oldReplicas, true);
    }

    private boolean onReplicasChange(PartitionReplica[] newReplicas, PartitionReplica[] oldReplicas, boolean invokeInterceptor) {
        PartitionReplica oldReplicasOwner = oldReplicas[0];
        PartitionReplica newReplicasOwner = newReplicas[0];
        boolean partitionOwnerChanged = this.onReplicaChange(0, oldReplicasOwner, newReplicasOwner, invokeInterceptor);
        for (int replicaIndex = 1; replicaIndex < 7; ++replicaIndex) {
            PartitionReplica oldReplicasId = oldReplicas[replicaIndex];
            PartitionReplica newReplicasId = newReplicas[replicaIndex];
            this.onReplicaChange(replicaIndex, oldReplicasId, newReplicasId, invokeInterceptor);
        }
        return partitionOwnerChanged;
    }

    @SuppressFBWarnings(value={"VO_VOLATILE_INCREMENT"}, justification="This method is called under InternalPartitionServiceImpl.lock")
    private boolean onReplicaChange(int replicaIndex, PartitionReplica oldReplica, PartitionReplica newReplica) {
        return this.onReplicaChange(replicaIndex, oldReplica, newReplica, true);
    }

    @SuppressFBWarnings(value={"VO_VOLATILE_INCREMENT"}, justification="This method is called under InternalPartitionServiceImpl.lock")
    private boolean onReplicaChange(int replicaIndex, PartitionReplica oldReplica, PartitionReplica newReplica, boolean invokeInterceptor) {
        boolean changed;
        if (oldReplica == null) {
            changed = newReplica != null;
        } else {
            boolean bl = changed = !oldReplica.equals(newReplica);
        }
        if (!changed) {
            return false;
        }
        ++this.version;
        if (this.interceptor != null && invokeInterceptor) {
            this.interceptor.replicaChanged(this.partitionId, replicaIndex, oldReplica, newReplica);
        }
        return true;
    }

    InternalPartitionImpl copy(PartitionReplicaInterceptor interceptor) {
        return new InternalPartitionImpl(this.partitionId, this.localReplica, Arrays.copyOf(this.replicas, 7), this.version, interceptor);
    }

    @Override
    protected PartitionReplica[] replicas() {
        return this.replicas;
    }

    int replaceReplica(PartitionReplica oldReplica, PartitionReplica newReplica) {
        PartitionReplica currentReplica;
        for (int i2 = 0; i2 < 7 && (currentReplica = this.replicas[i2]) != null; ++i2) {
            if (!currentReplica.equals(oldReplica)) continue;
            PartitionReplica[] newReplicas = Arrays.copyOf(this.replicas, 7);
            newReplicas[i2] = newReplica;
            this.replicas = newReplicas;
            this.onReplicaChange(i2, oldReplica, newReplica);
            return i2;
        }
        return -1;
    }

    void reset(PartitionReplica localReplica) {
        assert (localReplica != null);
        this.replicas = new PartitionReplica[7];
        this.localReplica = localReplica;
        this.version = 0;
        this.resetMigrating();
    }
}

