/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.usercodedeployment.impl;

import com.hazelcast.config.UserCodeDeploymentConfig;
import com.hazelcast.internal.usercodedeployment.impl.ClassData;
import com.hazelcast.internal.usercodedeployment.impl.ClassLocator;
import com.hazelcast.internal.usercodedeployment.impl.ClassSource;
import com.hazelcast.internal.util.EmptyStatement;
import com.hazelcast.jet.impl.util.ReflectionUtils;
import com.hazelcast.logging.ILogger;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;

public final class ClassDataProvider {
    private final UserCodeDeploymentConfig.ProviderMode providerMode;
    private final ClassLoader parent;
    private final ConcurrentMap<String, ClassSource> classSourceMap;
    private final ConcurrentMap<String, ClassSource> clientClassSourceMap;
    private final ILogger logger;

    public ClassDataProvider(UserCodeDeploymentConfig.ProviderMode providerMode, ClassLoader parent, ConcurrentMap<String, ClassSource> classSourceMap, ConcurrentMap<String, ClassSource> clientClassSourceMap, ILogger logger) {
        this.providerMode = providerMode;
        this.parent = parent;
        this.classSourceMap = classSourceMap;
        this.clientClassSourceMap = clientClassSourceMap;
        this.logger = logger;
    }

    public ClassData getClassDataOrNull(String className) {
        ClassData classData = this.loadBytecodesFromClientCache(className);
        if (classData != null) {
            return classData;
        }
        if (this.providerMode == UserCodeDeploymentConfig.ProviderMode.OFF) {
            return null;
        }
        classData = this.loadBytecodesFromParent(className);
        if (classData == null && this.providerMode == UserCodeDeploymentConfig.ProviderMode.LOCAL_AND_CACHED_CLASSES) {
            classData = this.loadBytecodesFromCache(className);
        }
        return classData;
    }

    private ClassData loadBytecodesFromCache(String className) {
        ClassSource classSource = (ClassSource)this.classSourceMap.get(ClassLocator.extractMainClassName(className));
        if (classSource == null) {
            return null;
        }
        return classSource.getClassData(className);
    }

    private ClassData loadBytecodesFromClientCache(String className) {
        ClassSource classSource = (ClassSource)this.clientClassSourceMap.get(ClassLocator.extractMainClassName(className));
        if (classSource == null) {
            return null;
        }
        return classSource.getClassData(className);
    }

    private ClassData loadBytecodesFromParent(String className) {
        byte[] mainClassDefinition = this.loadBytecodeFromParent(className);
        if (mainClassDefinition == null) {
            return null;
        }
        Map<String, byte[]> innerClassDefinitions = this.loadInnerClasses(className);
        innerClassDefinitions = this.loadAnonymousClasses(className, innerClassDefinitions);
        ClassData classData = new ClassData();
        if (innerClassDefinitions != null) {
            classData.setInnerClassDefinitions(innerClassDefinitions);
        }
        classData.setMainClassDefinition(mainClassDefinition);
        return classData;
    }

    private Map<String, byte[]> loadAnonymousClasses(String className, Map<String, byte[]> innerClassDefinitions) {
        String innerClassName;
        boolean shouldContinue;
        int i2 = 1;
        while (shouldContinue = this.attemptToLoadClass(innerClassName = className + "$" + i2)) {
            byte[] innerByteCode = this.loadBytecodeFromParent(innerClassName);
            if (innerClassDefinitions == null) {
                innerClassDefinitions = new HashMap<String, byte[]>();
            }
            innerClassDefinitions.put(innerClassName, innerByteCode);
            ++i2;
        }
        return innerClassDefinitions;
    }

    private boolean attemptToLoadClass(String innerClassName) {
        try {
            this.parent.loadClass(innerClassName);
        }
        catch (ClassNotFoundException exception) {
            return false;
        }
        return true;
    }

    private Map<String, byte[]> loadInnerClasses(String className) {
        HashMap<String, byte[]> innerClassDefinitions = null;
        try {
            Class<?>[] declaredClasses;
            Class<?> aClass = this.parent.loadClass(className);
            for (Class<?> declaredClass : declaredClasses = aClass.getDeclaredClasses()) {
                String innerClassName = declaredClass.getName();
                byte[] innerByteCode = this.loadBytecodeFromParent(innerClassName);
                if (innerClassDefinitions == null) {
                    innerClassDefinitions = new HashMap<String, byte[]>();
                }
                innerClassDefinitions.put(innerClassName, innerByteCode);
            }
        }
        catch (ClassNotFoundException e) {
            EmptyStatement.ignore(e);
        }
        return innerClassDefinitions;
    }

    private byte[] loadBytecodeFromParent(String className) {
        try {
            return ReflectionUtils.getClassContent(className, this.parent);
        }
        catch (IOException e) {
            this.logger.severe(e);
            return null;
        }
    }
}

