/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.operation;

import com.hazelcast.jet.Util;
import com.hazelcast.jet.datamodel.Tuple2;
import com.hazelcast.jet.impl.execution.init.JetInitDataSerializerHook;
import com.hazelcast.jet.impl.operation.AsyncOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.impl.AllowedDuringPassiveState;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class GetJobIdsOperation
extends AsyncOperation
implements AllowedDuringPassiveState {
    public static final long ALL_JOBS = Long.MIN_VALUE;
    private String onlyName;
    private long onlyJobId = Long.MIN_VALUE;

    public GetJobIdsOperation() {
    }

    public GetJobIdsOperation(String onlyName, Long onlyJobId) {
        this.onlyName = onlyName;
        this.onlyJobId = onlyJobId == null ? Long.MIN_VALUE : onlyJobId;
    }

    public CompletableFuture<GetJobIdsResult> doRun() {
        return this.getJobCoordinationService().getJobIds(this.onlyName, this.onlyJobId);
    }

    @Override
    public int getClassId() {
        return 14;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeString(this.onlyName);
        out.writeLong(this.onlyJobId);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.onlyName = in.readString();
        this.onlyJobId = in.readLong();
    }

    public static final class GetJobIdsResult
    implements IdentifiedDataSerializable {
        public static final GetJobIdsResult EMPTY = new GetJobIdsResult(Collections.emptyList());
        private long[] jobIds;
        private boolean[] isLightJobs;

        public GetJobIdsResult() {
        }

        public GetJobIdsResult(long jobId, boolean isLightJob) {
            this.jobIds = new long[]{jobId};
            this.isLightJobs = new boolean[]{isLightJob};
        }

        public GetJobIdsResult(List<Tuple2<Long, Boolean>> result) {
            this.jobIds = new long[result.size()];
            this.isLightJobs = new boolean[result.size()];
            for (int i2 = 0; i2 < result.size(); ++i2) {
                Tuple2<Long, Boolean> tuple = result.get(i2);
                assert (tuple.f0() != null && tuple.f1() != null);
                this.jobIds[i2] = tuple.f0();
                this.isLightJobs[i2] = tuple.f1();
            }
        }

        public long[] getJobIds() {
            return this.jobIds;
        }

        public boolean[] getIsLightJobs() {
            return this.isLightJobs;
        }

        @Override
        public int getFactoryId() {
            return JetInitDataSerializerHook.FACTORY_ID;
        }

        @Override
        public int getClassId() {
            return 19;
        }

        @Override
        public void writeData(ObjectDataOutput out) throws IOException {
            out.writeLongArray(this.jobIds);
            out.writeBooleanArray(this.isLightJobs);
        }

        @Override
        public void readData(ObjectDataInput in) throws IOException {
            this.jobIds = in.readLongArray();
            this.isLightJobs = in.readBooleanArray();
        }

        public String toString() {
            return "GetJobIdsResult{jobs=" + this.formatJobs(false) + ", lightJobs=" + this.formatJobs(true) + "}";
        }

        private String formatJobs(boolean isLightJob) {
            return IntStream.range(0, this.jobIds.length).filter(i2 -> this.isLightJobs[i2] == isLightJob).mapToObj(i2 -> Util.idToString(this.jobIds[i2])).collect(Collectors.joining(", ", "[", "]"));
        }
    }
}

