/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.operation;

import com.hazelcast.jet.impl.TerminationMode;
import com.hazelcast.jet.impl.operation.AsyncJobOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;

public class TerminateJobOperation
extends AsyncJobOperation {
    private TerminationMode terminationMode;
    private boolean isLightJob;

    public TerminateJobOperation() {
    }

    public TerminateJobOperation(long jobId, TerminationMode mode, boolean isLightJob) {
        super(jobId);
        this.terminationMode = mode;
        this.isLightJob = isLightJob;
        assert (!isLightJob || this.terminationMode == TerminationMode.CANCEL_FORCEFUL);
    }

    public CompletableFuture<Void> doRun() {
        if (this.isLightJob) {
            this.getJobCoordinationService().terminateLightJob(this.jobId(), true);
            return CompletableFuture.completedFuture(null);
        }
        return this.getJobCoordinationService().terminateJob(this.jobId(), this.terminationMode, true);
    }

    @Override
    public int getClassId() {
        return 22;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeByte(this.terminationMode.ordinal());
        out.writeBoolean(this.isLightJob);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.terminationMode = TerminationMode.values()[in.readByte()];
        this.isLightJob = in.readBoolean();
    }
}

