/*
 * Decompiled with CFR 0.152.
 */
package net.messagevortex.blender.recipes;

import java.io.IOException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import net.messagevortex.ExtendedSecureRandom;
import net.messagevortex.asn1.IdentityStoreBlock;
import net.messagevortex.asn1.RoutingCombo;

public abstract class BlenderRecipe
implements Comparable<BlenderRecipe> {
    static final Map<String, Set<BlenderRecipe>> recipes = new HashMap<String, Set<BlenderRecipe>>();
    private static final SecureRandom esr = ExtendedSecureRandom.getSecureRandom();
    private static final String DEFAULT = "default";

    public static BlenderRecipe getRecipe(String identifier, Set<IdentityStoreBlock> anonSet) throws IOException {
        if (identifier == null) {
            identifier = DEFAULT;
        }
        if (recipes.get(identifier) == null || recipes.get(identifier).size() == 0) {
            throw new IOException("Set of recipes is empty or does not exist");
        }
        ArrayList<BlenderRecipe> l = new ArrayList<BlenderRecipe>();
        for (BlenderRecipe r : recipes.get(identifier)) {
            if (!r.isAppliable(anonSet)) continue;
            l.add(r);
        }
        if (l.size() == 0) {
            throw new IOException("No candidates found for the given anon set");
        }
        return (BlenderRecipe)l.get(esr.nextInt(l.size()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearRecipes(String identifier) {
        if (identifier == null) {
            identifier = DEFAULT;
        }
        Map<String, Set<BlenderRecipe>> map = recipes;
        synchronized (map) {
            Set<BlenderRecipe> r = recipes.remove(identifier);
            if (r != null) {
                r.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addRecipe(String identifier, BlenderRecipe add) {
        if (identifier == null) {
            identifier = DEFAULT;
        }
        Map<String, Set<BlenderRecipe>> map = recipes;
        synchronized (map) {
            if (recipes.get(identifier) == null) {
                recipes.put(identifier, new ConcurrentSkipListSet());
            }
            recipes.get(identifier).add(add);
        }
    }

    public abstract boolean isAppliable(Set<IdentityStoreBlock> var1);

    public abstract RoutingCombo applyRecipe(Set<IdentityStoreBlock> var1, IdentityStoreBlock var2, IdentityStoreBlock var3) throws IOException;

    @Override
    public int compareTo(BlenderRecipe o) {
        return ("" + this.hashCode()).compareTo("" + o.hashCode());
    }
}

