/*
 * Decompiled with CFR 0.152.
 */
package net.messagevortex.router;

import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.messagevortex.ExtendedSecureRandom;
import net.messagevortex.MessageVortexLogger;
import net.messagevortex.asn1.IdentityStore;
import net.messagevortex.asn1.IdentityStoreBlock;
import net.messagevortex.asn1.RoutingCombo;
import net.messagevortex.router.Edge;
import net.messagevortex.router.GraphSet;
import net.messagevortex.router.MessageFactory;

public class SimpleMessageFactory
extends MessageFactory {
    private static final Logger LOGGER = MessageVortexLogger.getLogger(new Throwable().getStackTrace()[0].getClassName());
    private final GraphSet graph = new GraphSet();
    private long minMessageTransferStart = 180L;
    private long maxMessageTransferTime = 1800L;
    private long minStepProcessSTime = 30L;

    public static MessageFactory buildMessage(String msg, int source, int target, IdentityStoreBlock[] anonGroupMembers, IdentityStore is) {
        SimpleMessageFactory fullmsg = new SimpleMessageFactory(msg, source, target, anonGroupMembers, is);
        fullmsg.hotspot = anonGroupMembers[ExtendedSecureRandom.nextInt(anonGroupMembers.length)];
        ((MessageFactory)fullmsg).build();
        return fullmsg;
    }

    public SimpleMessageFactory(String msg, int source, int target, IdentityStoreBlock[] anonGroupMembers, IdentityStore is) {
        this.msg = msg;
        this.graph.setAnonymitySet(anonGroupMembers);
        this.graph.setSource(anonGroupMembers[source]);
        this.graph.setTarget(anonGroupMembers[target]);
    }

    @Override
    public RoutingCombo build() {
        int numberOfGraphs = (int)((double)this.graph.getAnonymitySetSize() * 2.5);
        LOGGER.log(Level.FINE, "Create graph");
        while (this.graph.size() < numberOfGraphs || !this.graph.allTargetsReached()) {
            IdentityStoreBlock from = null;
            IdentityStoreBlock to = null;
            while (from == null || !this.graph.targetReached(from)) {
                from = this.graph.getAnonIdentity(ExtendedSecureRandom.nextInt(this.graph.getAnonymitySetSize()));
            }
            while (to == null || to == from || to.equals(from)) {
                to = this.graph.getAnonIdentity(ExtendedSecureRandom.nextInt(this.graph.getAnonymitySetSize()));
            }
            this.graph.add(new Edge(from, to, this.graph.size(), 0L));
        }
        LOGGER.log(Level.FINE, "Assigning time to graph");
        long minArrival = 0L;
        long maxArrival = 0L;
        for (int i2 = 0; i2 < this.graph.size(); ++i2) {
            long maxRemainingTime = this.maxMessageTransferTime - maxArrival;
            int remainingHops = this.graph.size() - i2;
            LOGGER.log(Level.FINEST, "calculating timing for minArival=" + minArrival + "/maxArrival=" + maxArrival + "/remainingTime=" + maxRemainingTime + "/remainingHps=" + remainingHops);
            long maxShare = maxRemainingTime - (long)remainingHops * this.minStepProcessSTime - 2L;
            long share = Math.max(1L, maxShare / (long)remainingHops);
            maxShare = Math.max(2L, maxShare);
            LOGGER.log(Level.FINEST, "calculated shares are maxShare=" + maxShare + "/share=" + share);
            assert (share > 0L) : "share is negative (" + share + ")";
            long minTime = (long)ExtendedSecureRandom.nextRandomTime(minArrival + this.minMessageTransferStart, minArrival + this.minMessageTransferStart + share, minArrival + this.minMessageTransferStart + maxShare);
            maxRemainingTime = this.maxMessageTransferTime - minTime;
            maxShare = maxRemainingTime - (long)remainingHops * this.minStepProcessSTime - 2L;
            share = Math.max(1L, maxShare / (long)remainingHops);
            maxShare = Math.max(2L, maxShare);
            long maxTime = (long)ExtendedSecureRandom.nextRandomTime(minTime, minTime + share + 1L, minTime + maxShare + 2L);
            Edge g = this.graph.get(i2);
            g.setStartTime(minArrival - minTime);
            g.setDelayTime(maxTime - minTime);
            maxArrival = maxTime + this.minStepProcessSTime;
            minArrival = minTime + this.minStepProcessSTime;
        }
        return this.buildRoutingBlock();
    }

    private RoutingCombo buildRoutingBlock() {
        return this.graph.getRoutingBlock();
    }

    public long setMaxTransferTime(long newmax) {
        long ret = this.maxMessageTransferTime;
        this.maxMessageTransferTime = newmax;
        return ret;
    }

    public long setMinStepProcessSTime(long newmin) {
        long ret = this.minStepProcessSTime;
        this.minStepProcessSTime = newmin;
        return ret;
    }

    public long getMinMessageTransferStart(long newmin) {
        long ret = this.minMessageTransferStart;
        this.minMessageTransferStart = newmin;
        return ret;
    }

    @Override
    public GraphSet getGraph() {
        return this.graph;
    }

    public static void main(String[] args) throws IOException {
        LOGGER.log(Level.INFO, "Loading identity store");
        IdentityStore identityStore = new IdentityStore(new File("identityStore.cfg"));
        LOGGER.log(Level.INFO, "getting anon set");
        IdentityStoreBlock[] anonSet = identityStore.getAnonSet(5).toArray(new IdentityStoreBlock[0]);
        LOGGER.log(Level.INFO, "creating message factory");
        SimpleMessageFactory smf = new SimpleMessageFactory("", 0, 1, anonSet, identityStore);
        LOGGER.log(Level.INFO, "building routing block");
        smf.setMaxTransferTime(1800L);
        smf.setMinStepProcessSTime(30L);
        smf.build();
        LOGGER.log(Level.INFO, "done building");
    }
}

