/*
 * Decompiled with CFR 0.152.
 */
package net.messagevortex.transport;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.messagevortex.MessageVortexLogger;
import net.messagevortex.transport.SecurityContext;
import net.messagevortex.transport.SecurityRequirement;
import net.messagevortex.transport.ServerConnection;
import net.messagevortex.transport.SocketListener;

public class ListeningSocketChannel {
    static final Logger LOGGER = MessageVortexLogger.getLogger(new Throwable().getStackTrace()[0].getClassName());
    final InternalThread thread;
    private String protocol = "unknown";
    private SecurityContext context = null;

    public ListeningSocketChannel(InetSocketAddress address, SocketListener listener) throws IOException {
        ServerSocketChannel channel = ServerSocketChannel.open();
        channel.socket().bind(address);
        this.thread = new InternalThread(channel);
        this.thread.setSocketListener(listener);
        this.thread.start();
    }

    public SocketListener setSocketListener(SocketListener listener) {
        return this.thread.setSocketListener(listener);
    }

    public void setName(String name) {
        this.thread.setName(name);
    }

    public String getName() {
        return this.thread.getName();
    }

    public SocketListener getSocketListener() {
        return this.thread.getSocketListener();
    }

    public String setProtocol(String protocol) {
        String ret = this.protocol;
        this.protocol = protocol;
        return ret;
    }

    public SecurityContext setSecurityContext(SecurityContext context) {
        SecurityContext ret = this.context;
        this.context = context;
        return ret;
    }

    public SecurityContext getSecurityContext() {
        return this.context;
    }

    public int getPort() {
        return this.thread.getPort();
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void shutdown() {
        this.thread.shutdown();
        while (this.thread.isAlive()) {
            try {
                this.thread.join();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public boolean isShutdown() {
        return this.thread.isAlive();
    }

    private class InternalThread
    extends Thread {
        ServerSocketChannel serverSocketChannel = null;
        private SocketListener listener = null;
        private volatile boolean shutdown = false;

        public InternalThread(ServerSocketChannel channel) throws IOException {
            channel.configureBlocking(false);
            this.serverSocketChannel = channel;
        }

        public void shutdown() {
            this.shutdown = true;
        }

        public int getPort() {
            try {
                return ((InetSocketAddress)this.serverSocketChannel.getLocalAddress()).getPort();
            }
            catch (IOException ioe) {
                return -1;
            }
        }

        public SocketListener setSocketListener(SocketListener listener) {
            SocketListener ret = this.listener;
            this.listener = listener;
            return ret;
        }

        public SocketListener getSocketListener() {
            return this.listener;
        }

        @Override
        public void run() {
            block4: while (true) {
                try {
                    while (!this.shutdown) {
                        SocketChannel socketChannel = this.serverSocketChannel.accept();
                        if (socketChannel != null) {
                            if (this.listener != null) {
                                LOGGER.log(Level.INFO, "calling SocketChannel listener");
                                ServerConnection sc = new ServerConnection(socketChannel, ListeningSocketChannel.this.getSecurityContext());
                                if (ListeningSocketChannel.this.getSecurityContext() != null && ListeningSocketChannel.this.getSecurityContext().getRequirement() != null && (ListeningSocketChannel.this.getSecurityContext().getRequirement() == SecurityRequirement.UNTRUSTED_SSLTLS || ListeningSocketChannel.this.getSecurityContext().getRequirement() == SecurityRequirement.SSLTLS)) {
                                    sc.startTls();
                                }
                                this.listener.gotConnect(sc);
                                continue;
                            }
                            LOGGER.log(Level.SEVERE, "socketchannel listener is missing");
                            continue;
                        }
                        try {
                            Thread.sleep(10L);
                            continue block4;
                        }
                        catch (InterruptedException interruptedException) {
                        }
                    }
                    break;
                }
                catch (IOException ioe) {
                    LOGGER.log(Level.WARNING, "IOException while handling incomming connects", ioe);
                    break;
                }
            }
        }
    }
}

