/*
 * Decompiled with CFR 0.152.
 */
package net.messagevortex.transport;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextInputCallback;
import javax.security.sasl.RealmCallback;
import net.messagevortex.MessageVortexLogger;
import net.messagevortex.transport.Credentials;

public class SaslClientCallbackHandler
implements CallbackHandler {
    private static final Logger LOGGER = MessageVortexLogger.getLogger(new Throwable().getStackTrace()[0].getClassName());
    Credentials credentials;

    public SaslClientCallbackHandler(Credentials creds) {
        this.credentials = creds;
    }

    @Override
    public void handle(Callback[] cbs) {
        for (Callback cb : cbs) {
            if (cb instanceof NameCallback) {
                NameCallback nc = (NameCallback)cb;
                nc.setName(this.credentials.getUsername());
            } else if (cb instanceof PasswordCallback) {
                pc = (PasswordCallback)cb;
                ((PasswordCallback)pc).setPassword(this.credentials.getPassword().toCharArray());
            } else if (cb instanceof RealmCallback) {
                pc = (RealmCallback)cb;
                ((TextInputCallback)pc).setText(this.credentials.getRealm());
            } else {
                LOGGER.log(Level.SEVERE, "Server - unknown callback " + String.valueOf(cb));
            }
            System.out.flush();
        }
    }
}

