/*
 * Decompiled with CFR 0.152.
 */
package net.messagevortex.transport;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextInputCallback;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.SaslException;
import net.messagevortex.MessageVortexLogger;
import net.messagevortex.transport.AuthenticationProxy;
import net.messagevortex.transport.Credentials;

public class SaslServerCallbackHandler
implements CallbackHandler {
    private static final Logger LOGGER = MessageVortexLogger.getLogger(new Throwable().getStackTrace()[0].getClassName());
    private final AuthenticationProxy proxy;
    private String authnid = null;
    private String password = null;

    public SaslServerCallbackHandler(AuthenticationProxy creds) {
        this.proxy = creds;
    }

    @Override
    public void handle(Callback[] cbs) throws IOException {
        for (Callback cb : cbs) {
            Callback pc;
            Credentials creds = this.proxy.getCredentials(this.authnid);
            if (cb instanceof AuthorizeCallback) {
                AuthorizeCallback ac = (AuthorizeCallback)cb;
                ac.setAuthorizedID(this.authnid);
                ac.setAuthorized(true);
                continue;
            }
            if (cb instanceof NameCallback) {
                NameCallback nc = (NameCallback)cb;
                this.authnid = nc.getName() == null ? nc.getDefaultName() : nc.getName();
                LOGGER.log(Level.INFO, "Server sets authzid to " + this.authnid + " (" + nc.getName() + "/" + nc.getDefaultName() + ")");
                nc.setName(this.authnid);
                if (this.proxy.getCredentials(this.authnid) != null) continue;
                LOGGER.log(Level.WARNING, "Server did not find credentials for " + this.authnid);
                continue;
            }
            if (cb instanceof PasswordCallback) {
                pc = (PasswordCallback)cb;
                if (((PasswordCallback)pc).getPassword() != null) {
                    this.password = new String(((PasswordCallback)pc).getPassword());
                }
                LOGGER.log(Level.INFO, "got password " + this.password + " (correct password is " + (creds == null ? null : creds.getPassword()) + ")");
                if (creds == null || this.password != null && !creds.getPassword().equals(this.password)) {
                    throw new SaslException("unknown user or bad password");
                }
                ((PasswordCallback)pc).setPassword(creds.getPassword().toCharArray());
                continue;
            }
            if (cb instanceof RealmCallback) {
                pc = (RealmCallback)cb;
                if (creds == null) continue;
                ((TextInputCallback)pc).setText(creds.getRealm());
                continue;
            }
            LOGGER.log(Level.SEVERE, "Server - unknown callback " + String.valueOf(cb));
        }
    }
}

