/*
 * Decompiled with CFR 0.152.
 */
package net.messagevortex.transport;

import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import net.messagevortex.MessageVortexLogger;
import net.messagevortex.transport.CustomKeyManager;
import net.messagevortex.transport.SecurityRequirement;

public class SecurityContext {
    private static final Logger LOGGER = MessageVortexLogger.getLogger(new Throwable().getStackTrace()[0].getClassName());
    private SecurityRequirement requirement = SecurityRequirement.STARTTLS;
    private SSLContext context = null;
    private final Set<String> supportedCiphers = new HashSet<String>();

    public SecurityContext() {
    }

    public SecurityContext(SecurityRequirement requirement) {
        this.setRequirement(requirement);
    }

    public SecurityContext(SSLContext context) {
        this.setRequirement(null);
        this.setContext(context);
    }

    public SecurityContext(SSLContext context, SecurityRequirement req) {
        this.setRequirement(req);
        this.setContext(context);
    }

    private void init() {
        try {
            if (this.context == null) {
                this.context = SSLContext.getInstance("TLS");
                KeyManagerFactory keyManager = KeyManagerFactory.getInstance("SunX509");
                KeyStore keyStore = this.getSelfsignedKeyStore();
                keyManager.init(keyStore, "changeme".toCharArray());
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("SunX509");
                trustManagerFactory.init(keyStore);
                this.context.init(new KeyManager[]{new CustomKeyManager("keystore.jks", "changeme", "mykey3")}, trustManagerFactory.getTrustManagers(), new SecureRandom());
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Exception while creating SecurityContext", e);
        }
    }

    private KeyStore getSelfsignedKeyStore() {
        KeyStore keyStore = null;
        try {
            String commonName = "MessageVortex";
            String organizationalUnit = "MessageVortex";
            String organization = "none";
            String city = "none";
            String state = "none";
            String country = "none";
            int keysize = 2048;
            String alias = "selfsigned";
            char[] keyPass = "changeme".toCharArray();
            int validity = 3560;
            keyStore = KeyStore.getInstance("JKS");
            keyStore.load(null, null);
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            LOGGER.log(Level.WARNING, "Exception while creating keystore", e);
        }
        return keyStore;
    }

    public SSLContext getContext() {
        if (this.context == null) {
            // empty if block
        }
        return this.context;
    }

    public final SSLContext setContext(SSLContext context) {
        SSLContext ret = this.context;
        this.context = context;
        return ret;
    }

    public SecurityRequirement getRequirement() {
        return this.requirement;
    }

    public final SecurityRequirement setRequirement(SecurityRequirement requirement) {
        SecurityRequirement ret = this.requirement;
        this.requirement = requirement;
        return ret;
    }

    public boolean isCipherSupported(String name) {
        return this.supportedCiphers.contains(name);
    }

    public Set<String> getSupportedCiphers() {
        HashSet<String> ret = new HashSet<String>();
        ret.addAll(this.supportedCiphers);
        return ret;
    }
}

