/*
 * Decompiled with CFR 0.152.
 */
package net.messagevortex.transport.smtp;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import java.nio.channels.SocketChannel;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.messagevortex.Config;
import net.messagevortex.MessageVortexLogger;
import net.messagevortex.transport.ClientConnection;
import net.messagevortex.transport.Credentials;
import net.messagevortex.transport.SecurityContext;
import net.messagevortex.transport.TransportReceiver;
import org.bouncycastle.util.encoders.Base64;

public class SmtpConnection
extends ClientConnection {
    static final Logger LOGGER = MessageVortexLogger.getLogger(new Throwable().getStackTrace()[0].getClassName());
    private static volatile int id = 1;
    private String cfgSection;
    TransportReceiver receiver = null;
    InternalConnectionHandler handler = new InternalConnectionHandler();
    Credentials creds;

    public SmtpConnection(InetSocketAddress socketAddress, SecurityContext context, Credentials creds) throws IOException {
        super(socketAddress, context);
        this.init(creds);
    }

    public SmtpConnection(SocketChannel channel, SecurityContext secContext, Credentials creds) throws IOException {
        super(channel, secContext);
        this.init(creds);
    }

    private void init(Credentials creds) {
        this.setProtocol("smtp");
        this.creds = creds;
        this.handler.start();
    }

    public TransportReceiver getReceiver() {
        return this.receiver;
    }

    public TransportReceiver setReceiver(TransportReceiver receiver) {
        TransportReceiver ret = this.receiver;
        this.receiver = receiver;
        return ret;
    }

    public void setName(String name) {
        this.handler.setName(name);
    }

    private class InternalConnectionHandler
    extends Thread {
        private InternalConnectionHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.setName("SMTP" + id++);
            String command = null;
            try {
                LOGGER.log(Level.INFO, "got new SMTP incomming connect... sending server greeting");
                SmtpConnection.this.writeln("220 " + InetAddress.getLocalHost().getHostName() + " ESMTP MessageVortex receiver");
                String envelopeFrom = null;
                String envelopeTo = null;
                while (!"quit".equalsIgnoreCase(command)) {
                    LOGGER.log(Level.INFO, "Waiting for SMTP command to arrive");
                    command = "";
                    try {
                        command = SmtpConnection.this.readln();
                        LOGGER.log(Level.INFO, "got command '" + command + "'");
                        if (command.toLowerCase().startsWith("helo ")) {
                            SmtpConnection.this.write("250 Hi " + command.toLowerCase().substring(6) + " nice meeting you");
                            continue;
                        }
                        if (command.toLowerCase().startsWith("ehlo ")) {
                            SmtpConnection.this.write("250-Hi " + command.toLowerCase().substring(6) + " nice meeting you");
                            SmtpConnection.this.write("250-ENHANCEDSTATUSCODES\r\n");
                            SmtpConnection.this.write("250 AUTH login\r\n");
                            continue;
                        }
                        if ("auth login".equalsIgnoreCase(command)) {
                            SmtpConnection.this.writeln("334 " + new String(Base64.encode("Username:".getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8));
                            String username = new String(Base64.decode(SmtpConnection.this.readln()), StandardCharsets.UTF_8);
                            Config.getDefault().getStringValue(SmtpConnection.this.cfgSection, "smtp_incomming_user");
                            SmtpConnection.this.write("334 " + new String(Base64.encode("Password:".getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8) + "\r\n");
                            String password = new String(Base64.decode(SmtpConnection.this.readln()), StandardCharsets.UTF_8);
                            Config.getDefault().getStringValue(SmtpConnection.this.cfgSection, "smtp_incomming_password");
                            continue;
                        }
                        if (command.toLowerCase().startsWith("mail from")) {
                            envelopeFrom = command.substring(10).trim();
                            SmtpConnection.this.write("250 OK\r\n");
                            continue;
                        }
                        if (command.toLowerCase().startsWith("rcpt to")) {
                            envelopeTo = command.substring(8).trim();
                            SmtpConnection.this.write("250 OK\r\n");
                            continue;
                        }
                        if ("data".equalsIgnoreCase(command)) {
                            if (envelopeFrom != null && envelopeTo != null) {
                                SmtpConnection.this.write("354 send the mail data, end with CRLF.CRLF\r\n");
                                String l = null;
                                StringBuilder sb = new StringBuilder();
                                while (!".".equals(l)) {
                                    if (l != null) {
                                        sb.append(l).append("\r\n");
                                    }
                                    l = SmtpConnection.this.readln();
                                }
                                if (SmtpConnection.this.getReceiver() != null) {
                                    LOGGER.log(Level.INFO, "Message passed to blender layer");
                                    SmtpConnection.this.getReceiver().gotMessage(new ByteArrayInputStream(sb.toString().getBytes(StandardCharsets.UTF_8)));
                                } else {
                                    LOGGER.log(Level.WARNING, "blender layer unknown ... message discarded");
                                }
                                SmtpConnection.this.write("250 OK\r\n");
                                continue;
                            }
                            SmtpConnection.this.write("554 ERROR\r\n");
                            continue;
                        }
                        if ("rset".equals(command.toLowerCase().trim())) {
                            envelopeFrom = null;
                            envelopeTo = null;
                            SmtpConnection.this.write("250 OK\r\n");
                            continue;
                        }
                        if ("noop".equals(command.toLowerCase().trim())) {
                            SmtpConnection.this.write("250 OK\r\n");
                            continue;
                        }
                        if ("quit".equals(command.toLowerCase().trim())) {
                            SmtpConnection.this.write("221 bye\r\n");
                            command = "quit";
                            continue;
                        }
                        SmtpConnection.this.write("500 Syntax Error\r\n");
                    }
                    catch (TimeoutException te) {
                        LOGGER.log(Level.INFO, "got Timeout while wating for command");
                    }
                }
            }
            catch (SocketTimeoutException ste) {
                LOGGER.log(Level.WARNING, "Connection closed due to timeout", ste);
            }
            catch (IOException ioe) {
                if (!SmtpConnection.this.isShutdown()) {
                    LOGGER.log(Level.WARNING, "error while communicating", ioe);
                }
            }
            finally {
                try {
                    SmtpConnection.this.shutdown();
                }
                catch (IOException ioe) {
                    LOGGER.log(Level.WARNING, "error while shutting down", ioe);
                }
            }
        }
    }
}

