/*
 * Decompiled with CFR 0.152.
 */
package net.messagevortex.transport.smtp;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Scanner;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.messagevortex.MessageVortexLogger;
import net.messagevortex.transport.ClientConnection;
import net.messagevortex.transport.Credentials;
import net.messagevortex.transport.SecurityContext;
import net.messagevortex.transport.SecurityRequirement;
import net.messagevortex.transport.TransportSender;
import org.bouncycastle.util.encoders.Base64;

public class SmtpSender
extends ClientConnection
implements TransportSender {
    private static final String CRLF = "\r\n";
    private static final Logger LOGGER = MessageVortexLogger.getLogger(new Throwable().getStackTrace()[0].getClassName());
    Credentials credentials = null;
    String senderAddress;

    public SmtpSender(String senderAddress, String server, int port, Credentials creds, SecurityContext context) throws IOException {
        super(new InetSocketAddress(server, port), context);
        this.senderAddress = senderAddress;
        this.credentials = creds;
        this.connect();
        if (!(this.credentials == null || this.isTls() || this.credentials.getSecurityRequirement() != SecurityRequirement.SSLTLS && this.credentials.getSecurityRequirement() != SecurityRequirement.UNTRUSTED_SSLTLS)) {
            LOGGER.log(Level.INFO, "doing TLS handshake");
            this.startTls();
        }
    }

    @Override
    public void sendMessage(String address, InputStream is) throws IOException {
        try {
            String reply;
            LOGGER.log(Level.INFO, "waiting for server greeting");
            String serverGreeting = this.readln();
            if (!serverGreeting.startsWith("220 ")) {
                throw new IOException("Unable to communicate with server  (Greeting was '" + serverGreeting + "' )");
            }
            LOGGER.log(Level.INFO, "got greeting ... sending ehlo");
            this.write("EHLO " + InetAddress.getLocalHost().getHostName() + CRLF);
            Object[] ehloReply = this.getReply();
            if (!ehloReply[ehloReply.length - 1].startsWith("250 ")) {
                throw new IOException("Invalid EHLO reply  (Reply was '" + Arrays.toString(ehloReply).replaceAll(",", "\n") + "' )");
            }
            if (this.credentials != null && (this.credentials.getSecurityRequirement() == SecurityRequirement.STARTTLS || this.credentials.getSecurityRequirement() == SecurityRequirement.UNTRUSTED_STARTTLS)) {
                LOGGER.log(Level.INFO, "issuing STARTTLS command");
                this.write("STARTTLS\r\n");
                reply = this.readln();
                if (!reply.startsWith("220 ")) {
                    throw new IOException("Invalid STARTTLS reply  (Reply was '" + reply + "')");
                }
                this.startTls();
                this.write("EHLO " + InetAddress.getLocalHost().getHostName() + CRLF);
                ehloReply = this.getReply();
                if (!((String)ehloReply[ehloReply.length - 1]).startsWith("250 ")) {
                    throw new IOException("Invalid EHLO reply  (Reply was '" + Arrays.toString(ehloReply).replaceAll(",", "\n") + "' )");
                }
            }
            if (this.credentials != null && this.credentials.getUsername() != null) {
                LOGGER.log(Level.INFO, "sending credentials");
                this.sendAuth();
            }
            LOGGER.log(Level.INFO, "sending message");
            this.write("MAIL FROM: " + this.senderAddress + CRLF);
            reply = this.readln();
            if (reply == null || !reply.startsWith("250 ")) {
                throw new IOException("Invalid MAIL FROM reply  (Reply was '" + reply + "')");
            }
            this.write("RCPT TO: " + address + CRLF);
            reply = this.readln();
            if (reply == null || !reply.startsWith("250 ")) {
                throw new IOException("Invalid RCPT reply  (Reply was '" + reply + "')");
            }
            this.write("DATA\r\n");
            reply = this.readln();
            if (reply == null || !reply.startsWith("354 ")) {
                throw new IOException("Invalid DATA reply  (Reply was '" + reply + "')");
            }
            Scanner s = new Scanner(is, StandardCharsets.UTF_8.name()).useDelimiter("\\A");
            String txt = s.hasNext() ? s.next() : "";
            this.write(txt + "\r\n.\r\n");
            reply = this.readln();
            if (reply == null || !reply.startsWith("250 ")) {
                throw new IOException("Invalid EOD reply (Reply was '" + reply + "')");
            }
            LOGGER.log(Level.INFO, "data sent: " + reply);
            this.write("QUIT\r\n");
            reply = this.readln();
            if (reply == null || !reply.startsWith("221 ")) {
                throw new IOException("Invalid QUIT reply  (Reply was '" + reply + "')");
            }
            this.closeConnection();
        }
        catch (TimeoutException te) {
            LOGGER.log(Level.INFO, "got timeout exception while sending message");
        }
    }

    private void sendAuth() throws IOException, TimeoutException {
        this.write("AUTH login\r\n");
        String reply = this.readln();
        if (!reply.startsWith("334 ")) {
            throw new IOException("Invalid AUTH[1] reply  (Reply was '" + reply.substring(0, 4) + Arrays.toString(Base64.decode(reply.substring(4))) + "')");
        }
        this.writeln(new String(Base64.encode(this.credentials.getUsername().getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8));
        reply = this.readln();
        if (!reply.startsWith("334 ")) {
            throw new IOException("Invalid AUTH[2] reply  (Reply was '" + reply.substring(0, 4) + Arrays.toString(Base64.decode(reply.substring(4))) + "')");
        }
        this.writeln(new String(Base64.encode(this.credentials.getPassword().getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8));
        reply = this.readln();
        if (!reply.startsWith("235 ")) {
            throw new IOException("Invalid AUTH[3] reply  (Reply was '" + reply + "')");
        }
        LOGGER.log(Level.INFO, "Login successful: " + reply);
    }

    private void sendPlain() throws IOException, TimeoutException {
        Object txt = this.credentials.getUsername() + "\u0000" + this.credentials.getUsername() + "\u0000" + this.credentials.getPassword();
        txt = new String(Base64.encode(((String)txt).getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
        this.write("AUTH plain " + (String)txt + CRLF);
        String reply = this.readln();
        if (!reply.startsWith("235 ")) {
            throw new IOException("Invalid AUTH[1] reply  (Reply was '" + reply.substring(0, 4) + Arrays.toString(Base64.decode(reply.substring(4))) + "')");
        }
        LOGGER.log(Level.INFO, "Login successful: " + reply);
    }

    private String[] getReply() throws IOException, TimeoutException {
        ArrayList<String> replies = new ArrayList<String>();
        String line = null;
        while (line == null || line.length() < 4 || line.charAt(3) != ' ') {
            line = this.readln();
            replies.add(line);
        }
        return replies.toArray(new String[replies.size()]);
    }

    @Override
    public void shutdownDaemon() {
    }

    @Override
    public void startDaemon() {
    }

    @Override
    public void stopDaemon() {
    }
}

