/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.bcel.classfile.AnnotationEntry;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.Node;
import org.apache.bcel.classfile.ParameterAnnotations;
import org.apache.bcel.classfile.Visitor;

public class ParameterAnnotationEntry
implements Node {
    static final ParameterAnnotationEntry[] EMPTY_ARRAY = new ParameterAnnotationEntry[0];
    private final AnnotationEntry[] annotationTable;

    public static ParameterAnnotationEntry[] createParameterAnnotationEntries(Attribute[] attributes) {
        if (attributes == null) {
            return EMPTY_ARRAY;
        }
        ArrayList accumulatedAnnotations = new ArrayList(attributes.length);
        for (Attribute attribute : attributes) {
            ParameterAnnotations runtimeAnnotations;
            ParameterAnnotationEntry[] parameterAnnotationEntries;
            if (!(attribute instanceof ParameterAnnotations) || (parameterAnnotationEntries = (runtimeAnnotations = (ParameterAnnotations)attribute).getParameterAnnotationEntries()) == null) continue;
            Collections.addAll(accumulatedAnnotations, parameterAnnotationEntries);
        }
        return accumulatedAnnotations.toArray(EMPTY_ARRAY);
    }

    ParameterAnnotationEntry(DataInput input, ConstantPool constantPool) throws IOException {
        int annotationTableLength = input.readUnsignedShort();
        this.annotationTable = new AnnotationEntry[annotationTableLength];
        for (int i2 = 0; i2 < annotationTableLength; ++i2) {
            this.annotationTable[i2] = AnnotationEntry.read(input, constantPool, false);
        }
    }

    @Override
    public void accept(Visitor v) {
        v.visitParameterAnnotationEntry(this);
    }

    public void dump(DataOutputStream dos) throws IOException {
        dos.writeShort(this.annotationTable.length);
        for (AnnotationEntry entry : this.annotationTable) {
            entry.dump(dos);
        }
    }

    public AnnotationEntry[] getAnnotationEntries() {
        return this.annotationTable;
    }
}

