/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.digester3;

import java.lang.reflect.Method;

final class RecordedInvocation {
    private final Method invokedMethod;
    private final Object[] arguments;

    public RecordedInvocation(Method invokedMethod, Object[] arguments) {
        this.invokedMethod = invokedMethod;
        this.arguments = arguments;
    }

    public Method getInvokedMethod() {
        return this.invokedMethod;
    }

    public Object[] getArguments() {
        return this.arguments;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.invokedMethod.getDeclaringClass().getName());
        buffer.append(".");
        buffer.append(this.invokedMethod.getName());
        buffer.append("(");
        int count = this.arguments.length;
        for (int i2 = 0; i2 < count; ++i2) {
            Object arg = this.arguments[i2];
            if (i2 > 0) {
                buffer.append(", ");
            }
            this.convert(buffer, arg);
        }
        buffer.append(")");
        return buffer.toString();
    }

    protected void convert(StringBuilder buffer, Object input) {
        if (input == null) {
            buffer.append("<null>");
            return;
        }
        if (!(input instanceof Object[])) {
            buffer.append(input.toString());
            return;
        }
        buffer.append("(");
        buffer.append(input.getClass().getSimpleName());
        buffer.append("){");
        Object[] array = (Object[])input;
        int count = array.length;
        for (int i2 = 0; i2 < count; ++i2) {
            if (i2 > 0) {
                buffer.append(", ");
            }
            this.convert(buffer, array[i2]);
        }
        buffer.append("}");
    }
}

