/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.module.xhtml5;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.swing.text.html.HTML;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.doxia.macro.MacroExecutionException;
import org.apache.maven.doxia.macro.MacroRequest;
import org.apache.maven.doxia.macro.manager.MacroNotFoundException;
import org.apache.maven.doxia.module.xhtml5.Xhtml5Markup;
import org.apache.maven.doxia.parser.ParseException;
import org.apache.maven.doxia.parser.Xhtml5BaseParser;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.sink.impl.SinkEventAttributeSet;
import org.codehaus.plexus.util.xml.pull.XmlPullParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Named(value="xhtml")
public class Xhtml5Parser
extends Xhtml5BaseParser
implements Xhtml5Markup {
    private static final Logger LOGGER = LoggerFactory.getLogger(Xhtml5Parser.class);
    protected boolean source;
    private boolean isEmptyElement;
    private String sourceContent;

    @Override
    protected void handleStartTag(XmlPullParser parser, Sink sink) throws XmlPullParserException, MacroExecutionException {
        this.isEmptyElement = parser.isEmptyElementTag();
        SinkEventAttributeSet attribs = this.getAttributesFromParser(parser);
        if (parser.getName().equals(HTML.toString())) {
            return;
        }
        if (parser.getName().equals(HEAD.toString())) {
            sink.head(attribs);
        } else if (parser.getName().equals(TITLE.toString())) {
            sink.title(attribs);
        } else if (parser.getName().equals(META.toString())) {
            String name = parser.getAttributeValue(null, HTML.Attribute.NAME.toString());
            String content = parser.getAttributeValue(null, HTML.Attribute.CONTENT.toString());
            if ("author".equals(name)) {
                sink.author(null);
                sink.text(content);
                sink.author_();
            } else if ("date".equals(name)) {
                sink.date(null);
                sink.text(content);
                sink.date_();
            } else {
                sink.unknown("meta", new Object[]{1}, attribs);
            }
        } else if (parser.getName().equals(ADDRESS.toString())) {
            sink.address(attribs);
        } else if (parser.getName().equals(BODY.toString())) {
            sink.body(attribs);
        } else if (parser.getName().equals(DIV.toString())) {
            String divClass = parser.getAttributeValue(null, HTML.Attribute.CLASS.toString());
            if ("verbatim source".equals(divClass)) {
                this.source = true;
            }
            this.baseStartTag(parser, sink);
        } else if (parser.getName().equals(PRE.toString())) {
            if (this.source) {
                attribs.addAttributes(SinkEventAttributeSet.SOURCE);
            }
            this.verbatim();
            sink.verbatim(attribs);
        } else if (!this.baseStartTag(parser, sink)) {
            if (this.isEmptyElement) {
                this.handleUnknown(parser, sink, 1);
            } else {
                this.handleUnknown(parser, sink, 2);
            }
            LOGGER.warn("Unrecognized xhtml5 tag <{}> at [{}:{}]", parser.getName(), parser.getLineNumber(), parser.getColumnNumber());
        }
    }

    @Override
    protected void handleEndTag(XmlPullParser parser, Sink sink) throws XmlPullParserException, MacroExecutionException {
        if (parser.getName().equals(HTML.toString())) {
            return;
        }
        if (parser.getName().equals(HEAD.toString())) {
            sink.head_();
        } else if (parser.getName().equals(TITLE.toString())) {
            sink.title_();
        } else if (parser.getName().equals(BODY.toString())) {
            this.emitHeadingSections(0, sink, false);
            sink.body_();
        } else if (parser.getName().equals(ADDRESS.toString())) {
            sink.address_();
        } else if (parser.getName().equals(DIV.toString())) {
            this.source = false;
            this.baseEndTag(parser, sink);
        } else if (!this.baseEndTag(parser, sink) && !this.isEmptyElement) {
            this.handleUnknown(parser, sink, 3);
        }
        this.isEmptyElement = false;
    }

    @Override
    protected void handleComment(XmlPullParser parser, Sink sink) throws XmlPullParserException {
        String text = this.getText(parser).trim();
        if (text.startsWith("MACRO") && !this.isSecondParsing()) {
            this.processMacro(text, sink);
        } else {
            super.handleComment(parser, sink);
        }
    }

    private void processMacro(String text, Sink sink) throws XmlPullParserException {
        String s = text.substring(text.indexOf(123) + 1, text.indexOf(125));
        s = this.escapeForMacro(s);
        String[] params = StringUtils.split(s, "|");
        String macroName = params[0];
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        for (int i2 = 1; i2 < params.length; ++i2) {
            String[] param = StringUtils.split(params[i2], "=");
            if (param.length == 1) {
                throw new XmlPullParserException("Missing 'key=value' pair for macro parameter: " + params[i2]);
            }
            String key = this.unescapeForMacro(param[0]);
            String value = this.unescapeForMacro(param[1]);
            parameters.put(key, value);
        }
        MacroRequest request = new MacroRequest(this.sourceContent, new Xhtml5Parser(), parameters, this.getBasedir());
        try {
            this.executeMacro(macroName, request, sink);
        }
        catch (MacroExecutionException e) {
            throw new XmlPullParserException("Unable to execute macro in the document: " + macroName);
        }
        catch (MacroNotFoundException me) {
            throw new XmlPullParserException("Macro not found: " + macroName);
        }
    }

    private String escapeForMacro(String s) {
        if (s == null || s.length() < 1) {
            return s;
        }
        String result = s;
        result = StringUtils.replace(result, "\\=", "\u0011");
        result = StringUtils.replace(result, "\\|", "\u0012");
        return result;
    }

    private String unescapeForMacro(String s) {
        if (s == null || s.length() < 1) {
            return s;
        }
        String result = s;
        result = StringUtils.replace(result, "\u0011", "=");
        result = StringUtils.replace(result, "\u0012", "|");
        return result;
    }

    @Override
    protected void init() {
        super.init();
        this.source = false;
        this.isEmptyElement = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parse(Reader source, Sink sink, String reference) throws ParseException {
        this.sourceContent = null;
        try (Reader reader = source;){
            StringWriter contentWriter = new StringWriter();
            IOUtils.copy(reader, (Writer)contentWriter);
            this.sourceContent = contentWriter.toString();
        }
        catch (IOException ex) {
            throw new ParseException("Error reading the input source", ex);
        }
        try {
            super.parse(new StringReader(this.sourceContent), sink, reference);
        }
        finally {
            this.sourceContent = null;
        }
    }
}

