/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.sink.impl;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.LinkedList;
import java.util.Queue;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.sink.impl.SinkWrapperFactory;

public class BufferingSinkProxyFactory
implements SinkWrapperFactory {
    @Override
    public Sink createWrapper(Sink delegate) {
        BufferingSinkProxy proxy = new BufferingSinkProxy(delegate);
        return (Sink)Proxy.newProxyInstance(delegate.getClass().getClassLoader(), new Class[]{BufferingSink.class}, (InvocationHandler)proxy);
    }

    public static BufferingSink castAsBufferingSink(Sink sink) {
        if (sink instanceof BufferingSink) {
            return (BufferingSink)sink;
        }
        throw new IllegalArgumentException("The given sink is not a BufferingSink but a " + sink.getClass());
    }

    @Override
    public int getPriority() {
        return 0;
    }

    private static final class BufferingSinkProxy
    implements InvocationHandler {
        private final Queue<MethodWithArguments> bufferedInvocations = new LinkedList<MethodWithArguments>();
        private final Sink delegate;
        private static final Method FLUSH_METHOD;
        private static final Method GET_BUFFERED_SINK_METHOD;
        private static final Method GET_DOCUMENT_LOCATOR_METHOD;

        BufferingSinkProxy(Sink delegate) {
            this.delegate = delegate;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.equals(FLUSH_METHOD)) {
                this.bufferedInvocations.forEach(i2 -> i2.invoke(this.delegate));
                this.bufferedInvocations.clear();
            } else {
                if (method.equals(GET_BUFFERED_SINK_METHOD)) {
                    return this.delegate;
                }
                if (method.equals(GET_DOCUMENT_LOCATOR_METHOD)) {
                    return this.delegate.getDocumentLocator();
                }
                this.bufferedInvocations.add(new MethodWithArguments(method, args));
            }
            if (method.getReturnType() != Void.TYPE) {
                throw new IllegalStateException("BufferingSinkProxy only works for methods returning void, but given method " + method + " requires another return type");
            }
            return null;
        }

        static {
            try {
                FLUSH_METHOD = Sink.class.getMethod("flush", new Class[0]);
                GET_BUFFERED_SINK_METHOD = BufferingSink.class.getMethod("getBufferedSink", new Class[0]);
                GET_DOCUMENT_LOCATOR_METHOD = BufferingSink.class.getMethod("getDocumentLocator", new Class[0]);
            }
            catch (NoSuchMethodException | SecurityException e) {
                throw new IllegalStateException("Could not find flush method in Sink!", e);
            }
        }
    }

    public static interface BufferingSink
    extends Sink {
        public Sink getBufferedSink();
    }

    private static final class MethodWithArguments {
        private final Method method;
        private final Object[] args;

        MethodWithArguments(Method method, Object[] args) {
            this.method = method;
            this.args = args;
        }

        void invoke(Object object) {
            try {
                this.method.invoke(object, this.args);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new IllegalStateException("Could not call buffered method " + this.method, e);
            }
        }
    }
}

