/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.sink.impl;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Stack;
import java.util.regex.Pattern;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.doxia.markup.HtmlMarkup;
import org.apache.maven.doxia.sink.SinkEventAttributes;
import org.apache.maven.doxia.sink.impl.AbstractXmlSink;
import org.apache.maven.doxia.sink.impl.SinkEventAttributeSet;
import org.apache.maven.doxia.sink.impl.SinkUtils;
import org.apache.maven.doxia.util.DoxiaUtils;
import org.apache.maven.doxia.util.HtmlTools;
import org.codehaus.plexus.util.xml.PrettyPrintXMLWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Xhtml5BaseSink
extends AbstractXmlSink
implements HtmlMarkup {
    private static final Logger LOGGER = LoggerFactory.getLogger(Xhtml5BaseSink.class);
    private final PrintWriter writer;
    private static final Pattern HIDDEN_CLASS_PATTERN = Pattern.compile("(?:.*\\s|^)hidden(?:\\s.*|$)");
    private StringBuffer textBuffer = new StringBuffer();
    private boolean headFlag;
    protected Stack<HTML.Tag> contentStack = new Stack();
    protected Stack<List<HTML.Tag>> inlineStack = new Stack();
    private boolean paragraphFlag;
    private VerbatimMode verbatimMode;
    private final LinkedList<int[]> cellJustifStack;
    private final LinkedList<Boolean> isCellJustifStack;
    private final LinkedList<Integer> cellCountStack;
    private boolean evenTableRow = true;
    private final LinkedList<StringWriter> tableContentWriterStack;
    private final LinkedList<StringWriter> tableCaptionWriterStack;
    private final LinkedList<PrettyPrintXMLWriter> tableCaptionXMLWriterStack;
    private final LinkedList<String> tableCaptionStack;
    protected MutableAttributeSet tableAttributes;

    public Xhtml5BaseSink(Writer out) {
        this.writer = new PrintWriter(out);
        this.cellJustifStack = new LinkedList();
        this.isCellJustifStack = new LinkedList();
        this.cellCountStack = new LinkedList();
        this.tableContentWriterStack = new LinkedList();
        this.tableCaptionWriterStack = new LinkedList();
        this.tableCaptionXMLWriterStack = new LinkedList();
        this.tableCaptionStack = new LinkedList();
        this.init();
    }

    protected StringBuffer getTextBuffer() {
        return this.textBuffer;
    }

    protected void setHeadFlag(boolean headFlag) {
        this.headFlag = headFlag;
    }

    protected boolean isHeadFlag() {
        return this.headFlag;
    }

    protected VerbatimMode getVerbatimMode() {
        return this.verbatimMode;
    }

    protected void setVerbatimMode(VerbatimMode mode) {
        this.verbatimMode = mode;
    }

    protected boolean isVerbatim() {
        return this.verbatimMode != VerbatimMode.OFF;
    }

    protected void setCellJustif(int[] justif) {
        this.cellJustifStack.addLast(justif);
        this.isCellJustifStack.addLast(Boolean.TRUE);
    }

    protected int[] getCellJustif() {
        return this.cellJustifStack.getLast();
    }

    protected void setCellCount(int count) {
        this.cellCountStack.addLast(count);
    }

    protected int getCellCount() {
        return this.cellCountStack.getLast();
    }

    @Override
    protected void init() {
        super.init();
        this.resetTextBuffer();
        this.cellJustifStack.clear();
        this.isCellJustifStack.clear();
        this.cellCountStack.clear();
        this.tableContentWriterStack.clear();
        this.tableCaptionWriterStack.clear();
        this.tableCaptionXMLWriterStack.clear();
        this.tableCaptionStack.clear();
        this.inlineStack.clear();
        this.headFlag = false;
        this.paragraphFlag = false;
        this.verbatimMode = VerbatimMode.OFF;
        this.evenTableRow = true;
        this.tableAttributes = null;
    }

    protected void resetTextBuffer() {
        this.textBuffer = new StringBuffer();
    }

    @Override
    public void article(SinkEventAttributes attributes) {
        MutableAttributeSet atts = SinkUtils.filterAttributes(attributes, SinkUtils.SINK_SECTION_ATTRIBUTES);
        this.writeStartTag(HtmlMarkup.ARTICLE, atts);
    }

    @Override
    public void article_() {
        this.writeEndTag(HtmlMarkup.ARTICLE);
    }

    @Override
    public void navigation(SinkEventAttributes attributes) {
        MutableAttributeSet atts = SinkUtils.filterAttributes(attributes, SinkUtils.SINK_SECTION_ATTRIBUTES);
        this.writeStartTag(HtmlMarkup.NAV, atts);
    }

    @Override
    public void navigation_() {
        this.writeEndTag(HtmlMarkup.NAV);
    }

    @Override
    public void sidebar(SinkEventAttributes attributes) {
        MutableAttributeSet atts = SinkUtils.filterAttributes(attributes, SinkUtils.SINK_SECTION_ATTRIBUTES);
        this.writeStartTag(HtmlMarkup.ASIDE, atts);
    }

    @Override
    public void sidebar_() {
        this.writeEndTag(HtmlMarkup.ASIDE);
    }

    @Override
    public void section(int level, SinkEventAttributes attributes) {
        this.onSection(level, attributes);
    }

    @Override
    public void sectionTitle(int level, SinkEventAttributes attributes) {
        this.onSectionTitle(level, attributes);
    }

    @Override
    public void sectionTitle_(int level) {
        this.onSectionTitle_(level);
    }

    @Override
    public void section_(int level) {
        this.onSection_(level);
    }

    protected void onSection(int depth, SinkEventAttributes attributes) {
        if (depth >= 1 && depth <= 6) {
            SinkEventAttributeSet att = new SinkEventAttributeSet();
            att.addAttributes(SinkUtils.filterAttributes(attributes, SinkUtils.SINK_BASE_ATTRIBUTES));
            this.writeStartTag(HtmlMarkup.SECTION, att);
        }
    }

    protected void onSection_(int depth) {
        if (depth >= 1 && depth <= 6) {
            this.writeEndTag(HtmlMarkup.SECTION);
        }
    }

    protected void onSectionTitle(int depth, SinkEventAttributes attributes) {
        MutableAttributeSet atts = SinkUtils.filterAttributes(attributes, SinkUtils.SINK_SECTION_ATTRIBUTES);
        if (depth == 1) {
            this.writeStartTag(HtmlMarkup.H1, atts);
        } else if (depth == 2) {
            this.writeStartTag(HtmlMarkup.H2, atts);
        } else if (depth == 3) {
            this.writeStartTag(HtmlMarkup.H3, atts);
        } else if (depth == 4) {
            this.writeStartTag(HtmlMarkup.H4, atts);
        } else if (depth == 5) {
            this.writeStartTag(HtmlMarkup.H5, atts);
        } else if (depth == 6) {
            this.writeStartTag(HtmlMarkup.H6, atts);
        }
    }

    protected void onSectionTitle_(int depth) {
        if (depth == 1) {
            this.writeEndTag(HtmlMarkup.H1);
        } else if (depth == 2) {
            this.writeEndTag(HtmlMarkup.H2);
        } else if (depth == 3) {
            this.writeEndTag(HtmlMarkup.H3);
        } else if (depth == 4) {
            this.writeEndTag(HtmlMarkup.H4);
        } else if (depth == 5) {
            this.writeEndTag(HtmlMarkup.H5);
        } else if (depth == 6) {
            this.writeEndTag(HtmlMarkup.H6);
        }
    }

    @Override
    public void header(SinkEventAttributes attributes) {
        MutableAttributeSet atts = SinkUtils.filterAttributes(attributes, SinkUtils.SINK_SECTION_ATTRIBUTES);
        this.writeStartTag(HtmlMarkup.HEADER, atts);
    }

    @Override
    public void header_() {
        this.writeEndTag(HtmlMarkup.HEADER);
    }

    @Override
    public void content(SinkEventAttributes attributes) {
        MutableAttributeSet atts = SinkUtils.filterAttributes(attributes, SinkUtils.SINK_SECTION_ATTRIBUTES);
        if (this.contentStack.empty()) {
            this.writeStartTag(this.contentStack.push(HtmlMarkup.MAIN), atts);
        } else {
            if (atts == null) {
                atts = new SinkEventAttributeSet(1);
            }
            String divClass = "content";
            if (atts.isDefined("class")) {
                divClass = divClass + " " + atts.getAttribute("class").toString();
            }
            atts.addAttribute("class", divClass);
            this.writeStartTag(this.contentStack.push(HtmlMarkup.DIV), atts);
        }
    }

    @Override
    public void content_() {
        try {
            this.writeEndTag(this.contentStack.pop());
        }
        catch (EmptyStackException emptyStackException) {
            // empty catch block
        }
    }

    @Override
    public void footer(SinkEventAttributes attributes) {
        MutableAttributeSet atts = SinkUtils.filterAttributes(attributes, SinkUtils.SINK_SECTION_ATTRIBUTES);
        this.writeStartTag(HtmlMarkup.FOOTER, atts);
    }

    @Override
    public void footer_() {
        this.writeEndTag(HtmlMarkup.FOOTER);
    }

    @Override
    public void list(SinkEventAttributes attributes) {
        if (this.paragraphFlag) {
            this.paragraph_();
        }
        MutableAttributeSet atts = SinkUtils.filterAttributes(attributes, SinkUtils.SINK_BASE_ATTRIBUTES);
        this.writeStartTag(HtmlMarkup.UL, atts);
    }

    @Override
    public void list_() {
        this.writeEndTag(HtmlMarkup.UL);
    }

    @Override
    public void listItem(SinkEventAttributes attributes) {
        MutableAttributeSet atts = SinkUtils.filterAttributes(attributes, SinkUtils.SINK_BASE_ATTRIBUTES);
        this.writeStartTag(HtmlMarkup.LI, atts);
    }

    @Override
    public void listItem_() {
        this.writeEndTag(HtmlMarkup.LI);
    }

    @Override
    public void numberedList(int numbering, SinkEventAttributes attributes) {
        if (this.paragraphFlag) {
            this.paragraph_();
        }
        String olStyle = "list-style-type: ";
        switch (numbering) {
            case 2: {
                olStyle = olStyle + "upper-alpha";
                break;
            }
            case 1: {
                olStyle = olStyle + "lower-alpha";
                break;
            }
            case 4: {
                olStyle = olStyle + "upper-roman";
                break;
            }
            case 3: {
                olStyle = olStyle + "lower-roman";
                break;
            }
            default: {
                olStyle = olStyle + "decimal";
            }
        }
        olStyle = olStyle + ";";
        MutableAttributeSet atts = SinkUtils.filterAttributes(attributes, SinkUtils.SINK_SECTION_ATTRIBUTES);
        if (atts == null) {
            atts = new SinkEventAttributeSet(1);
        }
        if (atts.isDefined("style")) {
            olStyle = olStyle + " " + atts.getAttribute("style").toString();
        }
        atts.addAttribute("style", olStyle);
        this.writeStartTag(HtmlMarkup.OL, atts);
    }

    @Override
    public void numberedList_() {
        this.writeEndTag(HtmlMarkup.OL);
    }

    @Override
    public void numberedListItem(SinkEventAttributes attributes) {
        MutableAttributeSet atts = SinkUtils.filterAttributes(attributes, SinkUtils.SINK_BASE_ATTRIBUTES);
        this.writeStartTag(HtmlMarkup.LI, atts);
    }

    @Override
    public void numberedListItem_() {
        this.writeEndTag(HtmlMarkup.LI);
    }

    @Override
    public void definitionList(SinkEventAttributes attributes) {
        if (this.paragraphFlag) {
            this.paragraph_();
        }
        MutableAttributeSet atts = SinkUtils.filterAttributes(attributes, SinkUtils.SINK_BASE_ATTRIBUTES);
        this.writeStartTag(HtmlMarkup.DL, atts);
    }

    @Override
    public void definitionList_() {
        this.writeEndTag(HtmlMarkup.DL);
    }

    @Override
    public void definedTerm(SinkEventAttributes attributes) {
        MutableAttributeSet atts = SinkUtils.filterAttributes(attributes, SinkUtils.SINK_BASE_ATTRIBUTES);
        this.writeStartTag(HtmlMarkup.DT, atts);
    }

    @Override
    public void definedTerm_() {
        this.writeEndTag(HtmlMarkup.DT);
    }

    @Override
    public void definition(SinkEventAttributes attributes) {
        MutableAttributeSet atts = SinkUtils.filterAttributes(attributes, SinkUtils.SINK_BASE_ATTRIBUTES);
        this.writeStartTag(HtmlMarkup.DD, atts);
    }

    @Override
    public void definition_() {
        this.writeEndTag(HtmlMarkup.DD);
    }

    @Override
    public void figure(SinkEventAttributes attributes) {
        this.writeStartTag(HtmlMarkup.FIGURE, attributes);
    }

    @Override
    public void figure_() {
        this.writeEndTag(HtmlMarkup.FIGURE);
    }

    @Override
    public void figureGraphics(String src, SinkEventAttributes attributes) {
        MutableAttributeSet filtered = SinkUtils.filterAttributes(attributes, SinkUtils.SINK_IMG_ATTRIBUTES);
        if (filtered != null) {
            filtered.removeAttribute("src".toString());
        }
        int count = attributes == null ? 1 : attributes.getAttributeCount() + 1;
        SinkEventAttributeSet atts = new SinkEventAttributeSet(count);
        atts.addAttribute("src", HtmlTools.escapeHTML(src, true));
        atts.addAttributes(filtered);
        this.writeStartTag(HtmlMarkup.IMG, atts, true);
    }

    @Override
    public void figureCaption(SinkEventAttributes attributes) {
        this.writeStartTag(HtmlMarkup.FIGCAPTION, attributes);
    }

    @Override
    public void figureCaption_() {
        this.writeEndTag(HtmlMarkup.FIGCAPTION);
    }

    @Override
    public void paragraph(SinkEventAttributes attributes) {
        this.paragraphFlag = true;
        MutableAttributeSet atts = SinkUtils.filterAttributes(attributes, SinkUtils.SINK_SECTION_ATTRIBUTES);
        this.writeStartTag(HtmlMarkup.P, atts);
    }

    @Override
    public void paragraph_() {
        if (this.paragraphFlag) {
            this.writeEndTag(HtmlMarkup.P);
            this.paragraphFlag = false;
        }
    }

    @Override
    public void data(String value, SinkEventAttributes attributes) {
        MutableAttributeSet atts = SinkUtils.filterAttributes(attributes, SinkUtils.SINK_BASE_ATTRIBUTES);
        SinkEventAttributeSet att = new SinkEventAttributeSet();
        if (value != null) {
            att.addAttribute("value", value);
        }
        att.addAttributes(atts);
        this.writeStartTag(HtmlMarkup.DATA, att);
    }

    @Override
    public void data_() {
        this.writeEndTag(HtmlMarkup.DATA);
    }

    @Override
    public void time(String datetime, SinkEventAttributes attributes) {
        MutableAttributeSet atts = SinkUtils.filterAttributes(attributes, SinkUtils.SINK_BASE_ATTRIBUTES);
        SinkEventAttributeSet att = new SinkEventAttributeSet();
        if (datetime != null) {
            att.addAttribute("datetime", datetime);
        }
        att.addAttributes(atts);
        this.writeStartTag(HtmlMarkup.TIME, att);
    }

    @Override
    public void time_() {
        this.writeEndTag(HtmlMarkup.TIME);
    }

    @Override
    public void address(SinkEventAttributes attributes) {
        MutableAttributeSet atts = SinkUtils.filterAttributes(attributes, SinkUtils.SINK_SECTION_ATTRIBUTES);
        this.writeStartTag(HtmlMarkup.ADDRESS, atts);
    }

    @Override
    public void address_() {
        this.writeEndTag(HtmlMarkup.ADDRESS);
    }

    @Override
    public void blockquote(SinkEventAttributes attributes) {
        MutableAttributeSet atts = SinkUtils.filterAttributes(attributes, SinkUtils.SINK_SECTION_ATTRIBUTES);
        this.writeStartTag(HtmlMarkup.BLOCKQUOTE, atts);
    }

    @Override
    public void blockquote_() {
        this.writeEndTag(HtmlMarkup.BLOCKQUOTE);
    }

    @Override
    public void division(SinkEventAttributes attributes) {
        MutableAttributeSet atts = SinkUtils.filterAttributes(attributes, SinkUtils.SINK_SECTION_ATTRIBUTES);
        this.writeStartTag(HtmlMarkup.DIV, atts);
    }

    @Override
    public void division_() {
        this.writeEndTag(HtmlMarkup.DIV);
    }

    @Override
    public void verbatim(SinkEventAttributes attributes) {
        MutableAttributeSet atts;
        if (this.paragraphFlag) {
            this.paragraph_();
        }
        if ((atts = SinkUtils.filterAttributes(attributes, SinkUtils.SINK_VERBATIM_ATTRIBUTES)) == null) {
            atts = new SinkEventAttributeSet();
        }
        this.verbatimMode = VerbatimMode.ON;
        if (atts.isDefined("decoration") && "source".equals(atts.getAttribute("decoration").toString())) {
            this.verbatimMode = VerbatimMode.ON_WITH_CODE;
        }
        atts.removeAttribute("decoration");
        this.writeStartTag(HtmlMarkup.PRE, atts);
        if (this.verbatimMode == VerbatimMode.ON_WITH_CODE) {
            this.writeStartTag(HtmlMarkup.CODE);
        }
    }

    @Override
    public void verbatim_() {
        if (this.verbatimMode == VerbatimMode.ON_WITH_CODE) {
            this.writeEndTag(HtmlMarkup.CODE);
        }
        this.writeEndTag(HtmlMarkup.PRE);
        this.verbatimMode = VerbatimMode.OFF;
    }

    @Override
    public void horizontalRule(SinkEventAttributes attributes) {
        MutableAttributeSet atts = SinkUtils.filterAttributes(attributes, SinkUtils.SINK_HR_ATTRIBUTES);
        this.writeSimpleTag(HtmlMarkup.HR, atts);
    }

    @Override
    public void table(SinkEventAttributes attributes) {
        this.tableContentWriterStack.addLast(new StringWriter());
        if (this.paragraphFlag) {
            this.paragraph_();
        }
        this.tableAttributes = attributes == null ? new SinkEventAttributeSet(0) : SinkUtils.filterAttributes(attributes, SinkUtils.SINK_TABLE_ATTRIBUTES);
    }

    @Override
    public void table_() {
        this.writeEndTag(HtmlMarkup.TABLE);
        if (!this.cellCountStack.isEmpty()) {
            this.cellCountStack.removeLast().toString();
        }
        if (this.tableContentWriterStack.isEmpty()) {
            LOGGER.warn("{}No table content", (Object)this.getLocationLogPrefix());
            return;
        }
        String tableContent = this.tableContentWriterStack.removeLast().toString();
        String tableCaption = null;
        if (!this.tableCaptionStack.isEmpty() && this.tableCaptionStack.getLast() != null) {
            tableCaption = this.tableCaptionStack.removeLast();
        }
        if (tableCaption != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(tableContent, 0, tableContent.indexOf(62) + 1);
            sb.append(tableCaption);
            sb.append(tableContent.substring(tableContent.indexOf(62) + 1));
            this.write(sb.toString());
        } else {
            this.write(tableContent);
        }
    }

    @Override
    public void tableRows(int[] justification, boolean grid) {
        this.setCellJustif(justification);
        SinkEventAttributeSet att = new SinkEventAttributeSet();
        String tableClass = "bodyTable" + (grid ? " bodyTableBorder" : "");
        if (this.tableAttributes.isDefined("class".toString())) {
            tableClass = tableClass + " " + this.tableAttributes.getAttribute("class").toString();
        }
        att.addAttribute("class", tableClass);
        att.addAttributes(this.tableAttributes);
        this.tableAttributes.removeAttributes(this.tableAttributes);
        this.writeStartTag(HtmlMarkup.TABLE, att);
        this.cellCountStack.addLast(0);
    }

    @Override
    public void tableRows_() {
        if (!this.cellJustifStack.isEmpty()) {
            this.cellJustifStack.removeLast();
        }
        if (!this.isCellJustifStack.isEmpty()) {
            this.isCellJustifStack.removeLast();
        }
        this.evenTableRow = true;
    }

    @Override
    public void tableRow(SinkEventAttributes attributes) {
        MutableAttributeSet attrs = SinkUtils.filterAttributes(attributes, SinkUtils.SINK_TR_ATTRIBUTES);
        if (attrs == null) {
            attrs = new SinkEventAttributeSet();
        }
        String rowClass = this.evenTableRow ? "a" : "b";
        boolean hidden = false;
        if (attrs.isDefined("class".toString())) {
            String givenRowClass = (String)attrs.getAttribute("class".toString());
            if (HIDDEN_CLASS_PATTERN.matcher(givenRowClass).matches()) {
                hidden = true;
            }
            rowClass = rowClass + " " + givenRowClass;
        }
        attrs.addAttribute("class", rowClass);
        this.writeStartTag(HtmlMarkup.TR, attrs);
        if (!hidden) {
            boolean bl = this.evenTableRow = !this.evenTableRow;
        }
        if (!this.cellCountStack.isEmpty()) {
            this.cellCountStack.removeLast();
            this.cellCountStack.addLast(0);
        }
    }

    @Override
    public void tableRow_() {
        this.writeEndTag(HtmlMarkup.TR);
    }

    @Override
    public void tableCell(SinkEventAttributes attributes) {
        this.tableCell(false, attributes);
    }

    @Override
    public void tableHeaderCell(SinkEventAttributes attributes) {
        this.tableCell(true, attributes);
    }

    private void tableCell(boolean headerRow, MutableAttributeSet attributes) {
        int[] cellJustif;
        int cellCount;
        HTML.Tag t;
        HTML.Tag tag = t = headerRow ? HtmlMarkup.TH : HtmlMarkup.TD;
        if (!(headerRow || this.cellCountStack == null || this.cellCountStack.isEmpty() || this.cellJustifStack == null || this.cellJustifStack.isEmpty() || this.getCellJustif() == null || (cellCount = this.getCellCount()) >= (cellJustif = this.getCellJustif()).length)) {
            if (attributes == null) {
                attributes = new SinkEventAttributeSet();
            }
            HashMap<Integer, String> hash = new HashMap<Integer, String>();
            hash.put(0, "center");
            hash.put(1, "left");
            hash.put(2, "right");
            String tdStyle = "text-align: " + (String)hash.get(cellJustif[cellCount]) + ";";
            if (attributes.isDefined("style")) {
                tdStyle = tdStyle + " " + attributes.getAttribute("style").toString();
            }
            attributes.addAttribute("style", tdStyle);
        }
        if (attributes == null) {
            this.writeStartTag(t, null);
        } else {
            this.writeStartTag(t, SinkUtils.filterAttributes(attributes, SinkUtils.SINK_TD_ATTRIBUTES));
        }
    }

    @Override
    public void tableCell_() {
        this.tableCell_(false);
    }

    @Override
    public void tableHeaderCell_() {
        this.tableCell_(true);
    }

    private void tableCell_(boolean headerRow) {
        HTML.Tag t = headerRow ? HtmlMarkup.TH : HtmlMarkup.TD;
        this.writeEndTag(t);
        if (!this.isCellJustifStack.isEmpty() && this.isCellJustifStack.getLast().equals(Boolean.TRUE) && !this.cellCountStack.isEmpty()) {
            int cellCount = Integer.parseInt(this.cellCountStack.removeLast().toString());
            this.cellCountStack.addLast(++cellCount);
        }
    }

    @Override
    public void tableCaption(SinkEventAttributes attributes) {
        StringWriter sw = new StringWriter();
        this.tableCaptionWriterStack.addLast(sw);
        this.tableCaptionXMLWriterStack.addLast(new PrettyPrintXMLWriter(sw));
        MutableAttributeSet atts = SinkUtils.filterAttributes(attributes, SinkUtils.SINK_SECTION_ATTRIBUTES);
        this.writeStartTag(HtmlMarkup.CAPTION, atts);
    }

    @Override
    public void tableCaption_() {
        this.writeEndTag(HtmlMarkup.CAPTION);
        if (!this.tableCaptionXMLWriterStack.isEmpty() && this.tableCaptionXMLWriterStack.getLast() != null) {
            this.tableCaptionStack.addLast(this.tableCaptionWriterStack.removeLast().toString());
            this.tableCaptionXMLWriterStack.removeLast();
        }
    }

    @Override
    public void anchor(String name, SinkEventAttributes attributes) {
        Objects.requireNonNull(name, "name cannot be null");
        if (this.headFlag) {
            return;
        }
        MutableAttributeSet atts = SinkUtils.filterAttributes(attributes, SinkUtils.SINK_BASE_ATTRIBUTES);
        String id = name;
        if (!DoxiaUtils.isValidId(id)) {
            id = DoxiaUtils.encodeId(name);
            LOGGER.debug("{}Modified invalid anchor name '{}' to '{}'", this.getLocationLogPrefix(), name, id);
        }
        SinkEventAttributeSet att = new SinkEventAttributeSet();
        att.addAttribute("id", id);
        att.addAttributes(atts);
        this.writeStartTag(HtmlMarkup.A, att);
    }

    @Override
    public void anchor_() {
        if (!this.headFlag) {
            this.writeEndTag(HtmlMarkup.A);
        }
    }

    @Override
    public void link(String name, SinkEventAttributes attributes) {
        Objects.requireNonNull(name, "name cannot be null");
        if (this.headFlag) {
            return;
        }
        MutableAttributeSet atts = SinkUtils.filterAttributes(attributes, SinkUtils.SINK_LINK_ATTRIBUTES);
        if (atts == null) {
            atts = new SinkEventAttributeSet();
        }
        if (DoxiaUtils.isExternalLink(name)) {
            String linkClass = "externalLink";
            if (atts.isDefined("class".toString())) {
                String givenLinkClass = (String)atts.getAttribute("class".toString());
                linkClass = linkClass + " " + givenLinkClass;
            }
            atts.addAttribute("class", linkClass);
        }
        atts.addAttribute("href", HtmlTools.escapeHTML(name));
        this.writeStartTag(HtmlMarkup.A, atts);
    }

    @Override
    public void link_() {
        if (!this.headFlag) {
            this.writeEndTag(HtmlMarkup.A);
        }
    }

    private void inlineSemantics(SinkEventAttributes attributes, String semantic, List<HTML.Tag> tags, HTML.Tag tag) {
        if (attributes.containsAttribute("semantics", semantic)) {
            SinkEventAttributes attributesNoSemantics = (SinkEventAttributes)attributes.copyAttributes();
            attributesNoSemantics.removeAttribute("semantics");
            this.writeStartTag(tag, attributesNoSemantics);
            tags.add(0, tag);
        }
    }

    @Override
    public void inline(SinkEventAttributes attributes) {
        if (!this.headFlag) {
            ArrayList<HTML.Tag> tags = new ArrayList<HTML.Tag>();
            if (attributes != null) {
                this.inlineSemantics(attributes, "emphasis", tags, HtmlMarkup.EM);
                this.inlineSemantics(attributes, "strong", tags, HtmlMarkup.STRONG);
                this.inlineSemantics(attributes, "small", tags, HtmlMarkup.SMALL);
                this.inlineSemantics(attributes, "line-through", tags, HtmlMarkup.S);
                this.inlineSemantics(attributes, "citation", tags, HtmlMarkup.CITE);
                this.inlineSemantics(attributes, "quote", tags, HtmlMarkup.Q);
                this.inlineSemantics(attributes, "definition", tags, HtmlMarkup.DFN);
                this.inlineSemantics(attributes, "abbreviation", tags, HtmlMarkup.ABBR);
                this.inlineSemantics(attributes, "italic", tags, HtmlMarkup.I);
                this.inlineSemantics(attributes, "bold", tags, HtmlMarkup.B);
                this.inlineSemantics(attributes, "code", tags, HtmlMarkup.CODE);
                this.inlineSemantics(attributes, "variable", tags, HtmlMarkup.VAR);
                this.inlineSemantics(attributes, "sample", tags, HtmlMarkup.SAMP);
                this.inlineSemantics(attributes, "keyboard", tags, HtmlMarkup.KBD);
                this.inlineSemantics(attributes, "superscript", tags, HtmlMarkup.SUP);
                this.inlineSemantics(attributes, "subscript", tags, HtmlMarkup.SUB);
                this.inlineSemantics(attributes, "annotation", tags, HtmlMarkup.U);
                this.inlineSemantics(attributes, "highlight", tags, HtmlMarkup.MARK);
                this.inlineSemantics(attributes, "ruby", tags, HtmlMarkup.RUBY);
                this.inlineSemantics(attributes, "rubyBase", tags, HtmlMarkup.RB);
                this.inlineSemantics(attributes, "rubyText", tags, HtmlMarkup.RT);
                this.inlineSemantics(attributes, "rubyTextContainer", tags, HtmlMarkup.RTC);
                this.inlineSemantics(attributes, "rubyParentheses", tags, HtmlMarkup.RP);
                this.inlineSemantics(attributes, "bidirectionalIsolation", tags, HtmlMarkup.BDI);
                this.inlineSemantics(attributes, "bidirectionalOverride", tags, HtmlMarkup.BDO);
                this.inlineSemantics(attributes, "phrase", tags, HtmlMarkup.SPAN);
                this.inlineSemantics(attributes, "insert", tags, HtmlMarkup.INS);
                this.inlineSemantics(attributes, "delete", tags, HtmlMarkup.DEL);
            }
            this.inlineStack.push(tags);
        }
    }

    @Override
    public void inline_() {
        if (!this.headFlag) {
            for (HTML.Tag tag : this.inlineStack.pop()) {
                this.writeEndTag(tag);
            }
        }
    }

    @Override
    public void italic() {
        this.inline(SinkEventAttributeSet.Semantics.ITALIC);
    }

    @Override
    public void italic_() {
        this.inline_();
    }

    @Override
    public void bold() {
        this.inline(SinkEventAttributeSet.Semantics.BOLD);
    }

    @Override
    public void bold_() {
        this.inline_();
    }

    @Override
    public void monospaced() {
        this.inline(SinkEventAttributeSet.Semantics.CODE);
    }

    @Override
    public void monospaced_() {
        this.inline_();
    }

    @Override
    public void lineBreak(SinkEventAttributes attributes) {
        if (this.headFlag || this.isVerbatim()) {
            this.getTextBuffer().append(EOL);
        } else {
            MutableAttributeSet atts = SinkUtils.filterAttributes(attributes, SinkUtils.SINK_BR_ATTRIBUTES);
            this.writeSimpleTag(HtmlMarkup.BR, atts);
        }
    }

    @Override
    public void lineBreakOpportunity(SinkEventAttributes attributes) {
        if (!this.headFlag && !this.isVerbatim()) {
            MutableAttributeSet atts = SinkUtils.filterAttributes(attributes, SinkUtils.SINK_BR_ATTRIBUTES);
            this.writeSimpleTag(HtmlMarkup.WBR, atts);
        }
    }

    @Override
    public void pageBreak() {
        this.comment(" PB ");
    }

    @Override
    public void nonBreakingSpace() {
        if (this.headFlag) {
            this.getTextBuffer().append(' ');
        } else {
            this.write("&#160;");
        }
    }

    @Override
    public void text(String text, SinkEventAttributes attributes) {
        if (attributes != null) {
            this.inline(attributes);
        }
        if (this.headFlag) {
            this.getTextBuffer().append(text);
        } else if (this.isVerbatim()) {
            this.verbatimContent(text);
        } else {
            this.content(text);
        }
        if (attributes != null) {
            this.inline_();
        }
    }

    @Override
    public void rawText(String text) {
        if (this.headFlag) {
            this.getTextBuffer().append(text);
        } else {
            this.write(text);
        }
    }

    @Override
    public void comment(String comment) {
        if (comment != null) {
            String originalComment = comment;
            while (comment.contains("--")) {
                comment = comment.replace("--", "- -");
            }
            if (comment.endsWith("-")) {
                comment = comment + " ";
            }
            if (!originalComment.equals(comment)) {
                LOGGER.warn("{}Modified invalid comment '{}' to '{}'", this.getLocationLogPrefix(), originalComment, comment);
            }
            StringBuilder buffer = new StringBuilder(comment.length() + 7);
            buffer.append('<').append('!').append('-').append('-');
            buffer.append(comment);
            buffer.append('-').append('-').append('>');
            this.write(buffer.toString());
        }
    }

    @Override
    public void unknown(String name, Object[] requiredParams, SinkEventAttributes attributes) {
        if (requiredParams == null || !(requiredParams[0] instanceof Integer)) {
            LOGGER.warn("{}No type information for unknown event '{}', ignoring!", (Object)this.getLocationLogPrefix(), (Object)name);
            return;
        }
        int tagType = (Integer)requiredParams[0];
        if (tagType == 4) {
            this.rawText(name);
            return;
        }
        if (tagType == 5) {
            this.rawText(EOL + "//<![CDATA[" + requiredParams[1] + "]]>" + EOL);
            return;
        }
        HTML.Tag tag = HtmlTools.getHtmlTag(name);
        if (tag == null) {
            LOGGER.warn("[]No HTML tag found for unknown event '{}', ignoring!", (Object)this.getLocationLogPrefix(), (Object)name);
        } else if (tagType == 1) {
            this.writeSimpleTag(tag, this.escapeAttributeValues(attributes));
        } else if (tagType == 2) {
            this.writeStartTag(tag, this.escapeAttributeValues(attributes));
        } else if (tagType == 3) {
            this.writeEndTag(tag);
        } else {
            LOGGER.warn("{}No type information for unknown event '{}', ignoring!", (Object)this.getLocationLogPrefix(), (Object)name);
        }
    }

    private SinkEventAttributes escapeAttributeValues(SinkEventAttributes attributes) {
        SinkEventAttributeSet set = new SinkEventAttributeSet(attributes.getAttributeCount());
        Enumeration<?> names = attributes.getAttributeNames();
        while (names.hasMoreElements()) {
            Object name = names.nextElement();
            set.addAttribute(name, Xhtml5BaseSink.escapeHTML(attributes.getAttribute(name).toString()));
        }
        return set;
    }

    @Override
    public void flush() {
        this.writer.flush();
    }

    @Override
    public void close() {
        this.writer.close();
        this.init();
    }

    protected void content(String text) {
        String txt = Xhtml5BaseSink.escapeHTML(text);
        txt = StringUtils.replace(txt, "&amp;#", "&#");
        this.write(txt);
    }

    protected void verbatimContent(String text) {
        this.write(Xhtml5BaseSink.escapeHTML(text));
    }

    protected static String escapeHTML(String text) {
        return HtmlTools.escapeHTML(text, false);
    }

    protected static String encodeURL(String text) {
        return HtmlTools.encodeURL(text);
    }

    @Override
    protected void write(String text) {
        if (!this.tableCaptionXMLWriterStack.isEmpty() && this.tableCaptionXMLWriterStack.getLast() != null) {
            this.tableCaptionXMLWriterStack.getLast().writeMarkup(Xhtml5BaseSink.unifyEOLs(text));
        } else if (!this.tableContentWriterStack.isEmpty() && this.tableContentWriterStack.getLast() != null) {
            this.tableContentWriterStack.getLast().write(Xhtml5BaseSink.unifyEOLs(text));
        } else {
            this.writer.write(Xhtml5BaseSink.unifyEOLs(text));
        }
    }

    @Override
    protected void writeStartTag(HTML.Tag t, MutableAttributeSet att, boolean isSimpleTag) {
        if (this.tableCaptionXMLWriterStack.isEmpty()) {
            super.writeStartTag(t, att, isSimpleTag);
        } else {
            String tag = (this.getNameSpace() != null ? this.getNameSpace() + ":" : "") + t.toString();
            this.tableCaptionXMLWriterStack.getLast().startElement(tag);
            if (att != null) {
                Enumeration<?> names = att.getAttributeNames();
                while (names.hasMoreElements()) {
                    Object key = names.nextElement();
                    Object value = att.getAttribute(key);
                    this.tableCaptionXMLWriterStack.getLast().addAttribute(key.toString(), value.toString());
                }
            }
            if (isSimpleTag) {
                this.tableCaptionXMLWriterStack.getLast().endElement();
            }
        }
    }

    @Override
    protected void writeEndTag(HTML.Tag t) {
        if (this.tableCaptionXMLWriterStack.isEmpty()) {
            super.writeEndTag(t);
        } else {
            this.tableCaptionXMLWriterStack.getLast().endElement();
        }
    }

    protected static enum VerbatimMode {
        OFF,
        ON,
        ON_WITH_CODE;

    }
}

