/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.site.io.xpp3;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.maven.doxia.site.Banner;
import org.apache.maven.doxia.site.Body;
import org.apache.maven.doxia.site.Image;
import org.apache.maven.doxia.site.LinkItem;
import org.apache.maven.doxia.site.Logo;
import org.apache.maven.doxia.site.Menu;
import org.apache.maven.doxia.site.MenuItem;
import org.apache.maven.doxia.site.PublishDate;
import org.apache.maven.doxia.site.SiteModel;
import org.apache.maven.doxia.site.Skin;
import org.apache.maven.doxia.site.Version;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.codehaus.plexus.util.xml.pull.EntityReplacementMap;
import org.codehaus.plexus.util.xml.pull.MXParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class SiteXpp3Reader {
    private boolean addDefaultEntities = true;
    public final ContentTransformer contentTransformer;

    public SiteXpp3Reader() {
        this(new ContentTransformer(){

            @Override
            public String transform(String source, String fieldName) {
                return source;
            }
        });
    }

    public SiteXpp3Reader(ContentTransformer contentTransformer) {
        this.contentTransformer = contentTransformer;
    }

    private boolean checkFieldWithDuplicate(XmlPullParser parser, String tagName, String alias, Set<String> parsed) throws XmlPullParserException {
        if (!parser.getName().equals(tagName) && !parser.getName().equals(alias)) {
            return false;
        }
        if (!parsed.add(tagName)) {
            throw new XmlPullParserException("Duplicated tag: '" + tagName + "'", parser, null);
        }
        return true;
    }

    private void checkUnknownAttribute(XmlPullParser parser, String attribute, String tagName, boolean strict) throws XmlPullParserException, IOException {
        if (strict) {
            throw new XmlPullParserException("Unknown attribute '" + attribute + "' for tag '" + tagName + "'", parser, null);
        }
    }

    private void checkUnknownElement(XmlPullParser parser, boolean strict) throws XmlPullParserException, IOException {
        if (strict) {
            throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
        }
        int unrecognizedTagCount = 1;
        while (unrecognizedTagCount > 0) {
            int eventType = parser.next();
            if (eventType == 2) {
                ++unrecognizedTagCount;
                continue;
            }
            if (eventType != 3) continue;
            --unrecognizedTagCount;
        }
    }

    public boolean getAddDefaultEntities() {
        return this.addDefaultEntities;
    }

    private boolean getBooleanValue(String s, String attribute, XmlPullParser parser) throws XmlPullParserException {
        return this.getBooleanValue(s, attribute, parser, null);
    }

    private boolean getBooleanValue(String s, String attribute, XmlPullParser parser, String defaultValue) throws XmlPullParserException {
        if (s != null && s.length() != 0) {
            return Boolean.valueOf(s);
        }
        if (defaultValue != null) {
            return Boolean.valueOf(defaultValue);
        }
        return false;
    }

    private byte getByteValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Byte.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a byte", parser, nfe);
                }
            }
        }
        return 0;
    }

    private char getCharacterValue(String s, String attribute, XmlPullParser parser) throws XmlPullParserException {
        if (s != null) {
            return s.charAt(0);
        }
        return '\u0000';
    }

    private Date getDateValue(String s, String attribute, XmlPullParser parser) throws XmlPullParserException {
        return this.getDateValue(s, attribute, null, parser);
    }

    private Date getDateValue(String s, String attribute, String dateFormat, XmlPullParser parser) throws XmlPullParserException {
        if (s != null) {
            String effectiveDateFormat = dateFormat;
            if (dateFormat == null) {
                effectiveDateFormat = "yyyy-MM-dd'T'HH:mm:ss.SSS";
            }
            if ("long".equals(effectiveDateFormat)) {
                try {
                    return new Date(Long.parseLong(s));
                }
                catch (NumberFormatException e) {
                    throw new XmlPullParserException(e.getMessage(), parser, e);
                }
            }
            try {
                SimpleDateFormat dateParser = new SimpleDateFormat(effectiveDateFormat, Locale.US);
                return dateParser.parse(s);
            }
            catch (ParseException e) {
                throw new XmlPullParserException(e.getMessage(), parser, e);
            }
        }
        return null;
    }

    private double getDoubleValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Double.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a floating point number", parser, nfe);
                }
            }
        }
        return 0.0;
    }

    private float getFloatValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Float.valueOf(s).floatValue();
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a floating point number", parser, nfe);
                }
            }
        }
        return 0.0f;
    }

    private int getIntegerValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Integer.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be an integer", parser, nfe);
                }
            }
        }
        return 0;
    }

    private long getLongValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Long.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a long integer", parser, nfe);
                }
            }
        }
        return 0L;
    }

    private String getRequiredAttributeValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        if (s == null && strict) {
            throw new XmlPullParserException("Missing required value for attribute '" + attribute + "'", parser, null);
        }
        return s;
    }

    private short getShortValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Short.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a short integer", parser, nfe);
                }
            }
        }
        return 0;
    }

    private String getTrimmedValue(String s) {
        if (s != null) {
            s = s.trim();
        }
        return s;
    }

    private String interpolatedTrimmed(String value, String context) {
        return this.getTrimmedValue(this.contentTransformer.transform(value, context));
    }

    private int nextTag(XmlPullParser parser) throws IOException, XmlPullParserException {
        int eventType = parser.next();
        if (eventType == 4) {
            eventType = parser.next();
        }
        if (eventType != 2 && eventType != 3) {
            throw new XmlPullParserException("expected START_TAG or END_TAG not " + XmlPullParser.TYPES[eventType], parser, null);
        }
        return eventType;
    }

    public SiteModel read(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        SiteModel siteModel = null;
        int eventType = parser.getEventType();
        boolean parsed = false;
        while (eventType != 1) {
            if (eventType == 2) {
                if (strict && !"site".equals(parser.getName())) {
                    throw new XmlPullParserException("Expected root element 'site' but found '" + parser.getName() + "'", parser, null);
                }
                if (parsed) {
                    throw new XmlPullParserException("Duplicated tag: 'site'", parser, null);
                }
                siteModel = this.parseSiteModel(parser, strict);
                siteModel.setModelEncoding(parser.getInputEncoding());
                parsed = true;
            }
            eventType = parser.next();
        }
        if (parsed) {
            return siteModel;
        }
        throw new XmlPullParserException("Expected root element 'site' but found no element at all: invalid XML document", parser, null);
    }

    public SiteModel read(Reader reader, boolean strict) throws IOException, XmlPullParserException {
        MXParser parser = this.addDefaultEntities ? new MXParser(EntityReplacementMap.defaultEntityReplacementMap) : new MXParser();
        parser.setInput(reader);
        return this.read(parser, strict);
    }

    public SiteModel read(Reader reader) throws IOException, XmlPullParserException {
        return this.read(reader, true);
    }

    public SiteModel read(InputStream in, boolean strict) throws IOException, XmlPullParserException {
        return this.read(new XmlStreamReader(in), strict);
    }

    public SiteModel read(InputStream in) throws IOException, XmlPullParserException {
        return this.read(new XmlStreamReader(in));
    }

    private Banner parseBanner(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        Banner banner = new Banner();
        for (int i2 = parser.getAttributeCount() - 1; i2 >= 0; --i2) {
            String name = parser.getAttributeName(i2);
            String value = parser.getAttributeValue(i2);
            if (name.indexOf(58) >= 0) continue;
            if ("name".equals(name)) {
                banner.setName(this.interpolatedTrimmed(value, "name"));
                continue;
            }
            if ("href".equals(name)) {
                banner.setHref(this.interpolatedTrimmed(value, "href"));
                continue;
            }
            if ("target".equals(name)) {
                banner.setTarget(this.interpolatedTrimmed(value, "target"));
                continue;
            }
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "image", null, parsed)) {
                banner.setImage(this.parseImage(parser, strict));
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return banner;
    }

    private Body parseBody(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        Body body = new Body();
        for (int i2 = parser.getAttributeCount() - 1; i2 >= 0; --i2) {
            String name = parser.getAttributeName(i2);
            String value = parser.getAttributeValue(i2);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "head", null, parsed)) {
                body.setHead(this.interpolatedTrimmed(parser.nextText(), "head"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "links", null, parsed)) {
                ArrayList<LinkItem> links = new ArrayList<LinkItem>();
                while (parser.nextTag() == 2) {
                    if ("item".equals(parser.getName())) {
                        links.add(this.parseLinkItem(parser, strict));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                body.setLinks(links);
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "breadcrumbs", null, parsed)) {
                ArrayList<LinkItem> breadcrumbs = new ArrayList<LinkItem>();
                while (parser.nextTag() == 2) {
                    if ("item".equals(parser.getName())) {
                        breadcrumbs.add(this.parseLinkItem(parser, strict));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                body.setBreadcrumbs(breadcrumbs);
                continue;
            }
            if ("menu".equals(parser.getName())) {
                List<Menu> menus = body.getMenus();
                if (menus == null) {
                    menus = new ArrayList<Menu>();
                }
                menus.add(this.parseMenu(parser, strict));
                body.setMenus(menus);
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "footer", null, parsed)) {
                body.setFooter(this.interpolatedTrimmed(parser.nextText(), "footer"));
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return body;
    }

    private Image parseImage(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        Image image = new Image();
        for (int i2 = parser.getAttributeCount() - 1; i2 >= 0; --i2) {
            String name = parser.getAttributeName(i2);
            String value = parser.getAttributeValue(i2);
            if (name.indexOf(58) >= 0) continue;
            if ("src".equals(name)) {
                image.setSrc(this.interpolatedTrimmed(value, "src"));
                continue;
            }
            if ("position".equals(name)) {
                image.setPosition(this.interpolatedTrimmed(value, "position"));
                continue;
            }
            if ("alt".equals(name)) {
                image.setAlt(this.interpolatedTrimmed(value, "alt"));
                continue;
            }
            if ("width".equals(name)) {
                image.setWidth(this.interpolatedTrimmed(value, "width"));
                continue;
            }
            if ("height".equals(name)) {
                image.setHeight(this.interpolatedTrimmed(value, "height"));
                continue;
            }
            if ("style".equals(name)) {
                image.setStyle(this.interpolatedTrimmed(value, "style"));
                continue;
            }
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            this.checkUnknownElement(parser, strict);
        }
        return image;
    }

    private LinkItem parseLinkItem(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        LinkItem linkItem = new LinkItem();
        for (int i2 = parser.getAttributeCount() - 1; i2 >= 0; --i2) {
            String name = parser.getAttributeName(i2);
            String value = parser.getAttributeValue(i2);
            if (name.indexOf(58) >= 0) continue;
            if ("name".equals(name)) {
                linkItem.setName(this.interpolatedTrimmed(value, "name"));
                continue;
            }
            if ("href".equals(name)) {
                linkItem.setHref(this.interpolatedTrimmed(value, "href"));
                continue;
            }
            if ("target".equals(name)) {
                linkItem.setTarget(this.interpolatedTrimmed(value, "target"));
                continue;
            }
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "image", null, parsed)) {
                linkItem.setImage(this.parseImage(parser, strict));
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return linkItem;
    }

    private Logo parseLogo(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        Logo logo = new Logo();
        for (int i2 = parser.getAttributeCount() - 1; i2 >= 0; --i2) {
            String name = parser.getAttributeName(i2);
            String value = parser.getAttributeValue(i2);
            if (name.indexOf(58) >= 0) continue;
            if ("name".equals(name)) {
                logo.setName(this.interpolatedTrimmed(value, "name"));
                continue;
            }
            if ("href".equals(name)) {
                logo.setHref(this.interpolatedTrimmed(value, "href"));
                continue;
            }
            if ("target".equals(name)) {
                logo.setTarget(this.interpolatedTrimmed(value, "target"));
                continue;
            }
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "image", null, parsed)) {
                logo.setImage(this.parseImage(parser, strict));
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return logo;
    }

    private Menu parseMenu(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        Menu menu = new Menu();
        for (int i2 = parser.getAttributeCount() - 1; i2 >= 0; --i2) {
            String name = parser.getAttributeName(i2);
            String value = parser.getAttributeValue(i2);
            if (name.indexOf(58) >= 0) continue;
            if ("name".equals(name)) {
                menu.setName(this.interpolatedTrimmed(value, "name"));
                continue;
            }
            if ("inherit".equals(name)) {
                menu.setInherit(this.interpolatedTrimmed(value, "inherit"));
                continue;
            }
            if ("inheritAsRef".equals(name)) {
                menu.setInheritAsRef(this.getBooleanValue(this.interpolatedTrimmed(value, "inheritAsRef"), "inheritAsRef", parser, "false"));
                continue;
            }
            if ("ref".equals(name)) {
                menu.setRef(this.interpolatedTrimmed(value, "ref"));
                continue;
            }
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "image", null, parsed)) {
                menu.setImage(this.parseImage(parser, strict));
                continue;
            }
            if ("item".equals(parser.getName())) {
                List<MenuItem> items = menu.getItems();
                if (items == null) {
                    items = new ArrayList<MenuItem>();
                }
                items.add(this.parseMenuItem(parser, strict));
                menu.setItems(items);
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return menu;
    }

    private MenuItem parseMenuItem(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        MenuItem menuItem = new MenuItem();
        for (int i2 = parser.getAttributeCount() - 1; i2 >= 0; --i2) {
            String name = parser.getAttributeName(i2);
            String value = parser.getAttributeValue(i2);
            if (name.indexOf(58) >= 0) continue;
            if ("collapse".equals(name)) {
                menuItem.setCollapse(this.getBooleanValue(this.interpolatedTrimmed(value, "collapse"), "collapse", parser, "false"));
                continue;
            }
            if ("ref".equals(name)) {
                menuItem.setRef(this.interpolatedTrimmed(value, "ref"));
                continue;
            }
            if ("name".equals(name)) {
                menuItem.setName(this.interpolatedTrimmed(value, "name"));
                continue;
            }
            if ("href".equals(name)) {
                menuItem.setHref(this.interpolatedTrimmed(value, "href"));
                continue;
            }
            if ("target".equals(name)) {
                menuItem.setTarget(this.interpolatedTrimmed(value, "target"));
                continue;
            }
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if ("item".equals(parser.getName())) {
                List<MenuItem> items = menuItem.getItems();
                if (items == null) {
                    items = new ArrayList<MenuItem>();
                }
                items.add(this.parseMenuItem(parser, strict));
                menuItem.setItems(items);
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "image", null, parsed)) {
                menuItem.setImage(this.parseImage(parser, strict));
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return menuItem;
    }

    private PublishDate parsePublishDate(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        PublishDate publishDate = new PublishDate();
        for (int i2 = parser.getAttributeCount() - 1; i2 >= 0; --i2) {
            String name = parser.getAttributeName(i2);
            String value = parser.getAttributeValue(i2);
            if (name.indexOf(58) >= 0) continue;
            if ("position".equals(name)) {
                publishDate.setPosition(this.interpolatedTrimmed(value, "position"));
                continue;
            }
            if ("format".equals(name)) {
                publishDate.setFormat(this.interpolatedTrimmed(value, "format"));
                continue;
            }
            if ("timezone".equals(name)) {
                publishDate.setTimezone(this.interpolatedTrimmed(value, "timezone"));
                continue;
            }
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            this.checkUnknownElement(parser, strict);
        }
        return publishDate;
    }

    private SiteModel parseSiteModel(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        SiteModel siteModel = new SiteModel();
        for (int i2 = parser.getAttributeCount() - 1; i2 >= 0; --i2) {
            String name = parser.getAttributeName(i2);
            String value = parser.getAttributeValue(i2);
            if (name.indexOf(58) >= 0 || "xmlns".equals(name)) continue;
            if ("name".equals(name)) {
                siteModel.setName(this.interpolatedTrimmed(value, "name"));
                continue;
            }
            if ("combine.self".equals(name)) {
                siteModel.setCombineSelf(this.interpolatedTrimmed(value, "combine.self"));
                continue;
            }
            if ("requireParent".equals(name)) {
                siteModel.setRequireParent(this.getBooleanValue(this.interpolatedTrimmed(value, "requireParent"), "requireParent", parser, "false"));
                continue;
            }
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "bannerLeft", null, parsed)) {
                siteModel.setBannerLeft(this.parseBanner(parser, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "bannerRight", null, parsed)) {
                siteModel.setBannerRight(this.parseBanner(parser, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "publishDate", null, parsed)) {
                siteModel.setPublishDate(this.parsePublishDate(parser, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "version", null, parsed)) {
                siteModel.setVersion(this.parseVersion(parser, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "edit", null, parsed)) {
                siteModel.setEdit(this.interpolatedTrimmed(parser.nextText(), "edit"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "poweredBy", null, parsed)) {
                ArrayList<Logo> poweredBy = new ArrayList<Logo>();
                while (parser.nextTag() == 2) {
                    if ("logo".equals(parser.getName())) {
                        poweredBy.add(this.parseLogo(parser, strict));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                siteModel.setPoweredBy(poweredBy);
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "skin", null, parsed)) {
                siteModel.setSkin(this.parseSkin(parser, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "body", null, parsed)) {
                siteModel.setBody(this.parseBody(parser, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "custom", null, parsed)) {
                siteModel.setCustom(Xpp3DomBuilder.build(parser, true));
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return siteModel;
    }

    private Skin parseSkin(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        Skin skin = new Skin();
        for (int i2 = parser.getAttributeCount() - 1; i2 >= 0; --i2) {
            String name = parser.getAttributeName(i2);
            String value = parser.getAttributeValue(i2);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet<String> parsed = new HashSet<String>();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "groupId", null, parsed)) {
                skin.setGroupId(this.interpolatedTrimmed(parser.nextText(), "groupId"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "artifactId", null, parsed)) {
                skin.setArtifactId(this.interpolatedTrimmed(parser.nextText(), "artifactId"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "version", null, parsed)) {
                skin.setVersion(this.interpolatedTrimmed(parser.nextText(), "version"));
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return skin;
    }

    private Version parseVersion(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        Version version = new Version();
        for (int i2 = parser.getAttributeCount() - 1; i2 >= 0; --i2) {
            String name = parser.getAttributeName(i2);
            String value = parser.getAttributeValue(i2);
            if (name.indexOf(58) >= 0) continue;
            if ("position".equals(name)) {
                version.setPosition(this.interpolatedTrimmed(value, "position"));
                continue;
            }
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            this.checkUnknownElement(parser, strict);
        }
        return version;
    }

    public void setAddDefaultEntities(boolean addDefaultEntities) {
        this.addDefaultEntities = addDefaultEntities;
    }

    public static interface ContentTransformer {
        public String transform(String var1, String var2);
    }
}

