/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.git.gitexe;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.command.info.InfoScmResult;
import org.apache.maven.scm.provider.git.AbstractGitScmProvider;
import org.apache.maven.scm.provider.git.command.GitCommand;
import org.apache.maven.scm.provider.git.gitexe.command.add.GitAddCommand;
import org.apache.maven.scm.provider.git.gitexe.command.blame.GitBlameCommand;
import org.apache.maven.scm.provider.git.gitexe.command.branch.GitBranchCommand;
import org.apache.maven.scm.provider.git.gitexe.command.changelog.GitChangeLogCommand;
import org.apache.maven.scm.provider.git.gitexe.command.checkin.GitCheckInCommand;
import org.apache.maven.scm.provider.git.gitexe.command.checkout.GitCheckOutCommand;
import org.apache.maven.scm.provider.git.gitexe.command.diff.GitDiffCommand;
import org.apache.maven.scm.provider.git.gitexe.command.info.GitInfoCommand;
import org.apache.maven.scm.provider.git.gitexe.command.remoteinfo.GitRemoteInfoCommand;
import org.apache.maven.scm.provider.git.gitexe.command.remove.GitRemoveCommand;
import org.apache.maven.scm.provider.git.gitexe.command.status.GitStatusCommand;
import org.apache.maven.scm.provider.git.gitexe.command.tag.GitTagCommand;
import org.apache.maven.scm.provider.git.gitexe.command.untag.GitUntagCommand;
import org.apache.maven.scm.provider.git.gitexe.command.update.GitUpdateCommand;
import org.apache.maven.scm.provider.git.repository.GitScmProviderRepository;
import org.apache.maven.scm.repository.ScmRepositoryException;

@Singleton
@Named(value="git")
public class GitExeScmProvider
extends AbstractGitScmProvider {
    private final Map<String, String> environmentVariables = new HashMap<String, String>();

    @Override
    protected GitCommand getAddCommand() {
        return new GitAddCommand();
    }

    @Override
    protected GitCommand getBranchCommand() {
        return new GitBranchCommand();
    }

    @Override
    protected GitCommand getChangeLogCommand() {
        return new GitChangeLogCommand();
    }

    @Override
    protected GitCommand getCheckInCommand() {
        return new GitCheckInCommand(this.environmentVariables);
    }

    @Override
    protected GitCommand getCheckOutCommand() {
        return new GitCheckOutCommand(this.environmentVariables);
    }

    @Override
    protected GitCommand getDiffCommand() {
        return new GitDiffCommand();
    }

    @Override
    protected GitCommand getExportCommand() {
        return null;
    }

    @Override
    protected GitCommand getRemoveCommand() {
        return new GitRemoveCommand();
    }

    @Override
    protected GitCommand getStatusCommand() {
        return new GitStatusCommand();
    }

    @Override
    protected GitCommand getTagCommand() {
        return new GitTagCommand();
    }

    @Override
    protected GitCommand getUntagCommand() {
        return new GitUntagCommand();
    }

    @Override
    protected GitCommand getUpdateCommand() {
        return new GitUpdateCommand();
    }

    @Override
    public GitCommand getInfoCommand() {
        return new GitInfoCommand();
    }

    @Override
    protected GitCommand getBlameCommand() {
        return new GitBlameCommand();
    }

    @Override
    protected GitCommand getRemoteInfoCommand() {
        return new GitRemoteInfoCommand(this.environmentVariables);
    }

    @Override
    protected String getRepositoryURL(File path) throws ScmException {
        InfoScmResult result = this.info(new GitScmProviderRepository(path.toPath().toUri().toASCIIString()), new ScmFileSet(path), null);
        if (result.getInfoItems().size() != 1) {
            throw new ScmRepositoryException("Cannot find URL: " + (result.getInfoItems().size() == 0 ? "no" : "multiple") + " items returned by the info command");
        }
        return result.getInfoItems().get(0).getURL();
    }

    public void setEnvironmentVariable(String key, String value) {
        this.environmentVariables.put(key, value);
    }
}

