/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.runtime.directive;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.apache.velocity.context.InternalContextAdapter;
import org.apache.velocity.exception.TemplateInitException;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.directive.Directive;
import org.apache.velocity.runtime.directive.MacroParseException;
import org.apache.velocity.runtime.parser.ParseException;
import org.apache.velocity.runtime.parser.Token;
import org.apache.velocity.runtime.parser.node.Node;

public class Macro
extends Directive {
    private static boolean debugMode = false;

    @Override
    public String getName() {
        return "macro";
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public boolean isScopeProvided() {
        return false;
    }

    @Override
    public boolean render(InternalContextAdapter context, Writer writer, Node node) throws IOException {
        return true;
    }

    @Override
    public void init(RuntimeServices rs, InternalContextAdapter context, Node node) throws TemplateInitException {
        super.init(rs, context, node);
        List<MacroArg> macroArgs = Macro.getArgArray(node, this.rsvc);
        int numArgs = node.jjtGetNumChildren();
        this.rsvc.addVelocimacro(macroArgs.get((int)0).name, node.jjtGetChild(numArgs - 1), macroArgs, node.getTemplate());
    }

    @Override
    public void checkArgs(ArrayList<Integer> argtypes, Token t, String templateName) throws ParseException {
        if (argtypes.size() < 1) {
            throw new MacroParseException("A macro definition requires at least a macro name", templateName, t);
        }
        if (argtypes.get(0) != 11) {
            throw new MacroParseException("Macro argument 1 must be a token without surrounding ' or \"", templateName, t);
        }
        boolean consecutive = false;
        for (int argPos = 1; argPos < argtypes.size(); ++argPos) {
            if (argtypes.get(argPos) == 12) {
                ++argPos;
                consecutive = true;
                continue;
            }
            if (argtypes.get(argPos) != 20) {
                throw new MacroParseException("Macro argument " + (argPos + 1) + " must be a reference", templateName, t);
            }
            if (!consecutive) continue;
            throw new MacroParseException("Macro non-default argument follows a default argument at ", templateName, t);
        }
    }

    private static List<MacroArg> getArgArray(Node node, RuntimeServices rsvc) {
        int numArgs = node.jjtGetNumChildren();
        --numArgs;
        ArrayList<MacroArg> macroArgs = new ArrayList<MacroArg>();
        for (int i2 = 0; i2 < numArgs; ++i2) {
            Node curnode = node.jjtGetChild(i2);
            MacroArg macroArg = new MacroArg();
            if (curnode.getType() == 12) {
                macroArg.name = curnode.getFirstTokenImage();
                macroArg.defaultVal = curnode = node.jjtGetChild(++i2);
            } else {
                macroArg.name = curnode.getFirstTokenImage();
            }
            if (i2 > 0 && macroArg.name.startsWith(String.valueOf(rsvc.getParserConfiguration().getDollarChar()))) {
                macroArg.name = macroArg.name.substring(1);
            }
            macroArgs.add(macroArg);
        }
        if (debugMode) {
            StringBuilder msg = new StringBuilder("Macro.getArgArray(): nbrArgs=");
            msg.append(numArgs).append(": ");
            Macro.macroToString(msg, macroArgs, rsvc);
            rsvc.getLog("macro").debug(msg.toString());
        }
        return macroArgs;
    }

    public static StringBuilder macroToString(StringBuilder buf, List<MacroArg> macroArgs, RuntimeServices rsvc) {
        StringBuilder ret = buf == null ? new StringBuilder() : buf;
        ret.append(rsvc.getParserConfiguration().getHashChar()).append(macroArgs.get((int)0).name).append("( ");
        for (MacroArg marg : macroArgs) {
            ret.append(rsvc.getParserConfiguration().getDollarChar()).append(marg.name);
            if (marg.defaultVal != null) {
                ret.append("=").append(marg.defaultVal);
            }
            ret.append(' ');
        }
        ret.append(" )");
        return ret;
    }

    public static class MacroArg {
        public String name = null;
        public Node defaultVal = null;
    }
}

