/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.legacy.math.linearalgebra;

import java.security.SecureRandom;
import org.bouncycastle.pqc.legacy.math.linearalgebra.IntUtils;
import org.bouncycastle.pqc.legacy.math.linearalgebra.IntegerFunctions;
import org.bouncycastle.pqc.legacy.math.linearalgebra.LittleEndianConversions;
import org.bouncycastle.pqc.legacy.math.linearalgebra.RandUtils;
import org.bouncycastle.util.Arrays;

public class Permutation {
    private int[] perm;

    public Permutation(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("invalid length");
        }
        this.perm = new int[n];
        for (int j = n - 1; j >= 0; --j) {
            this.perm[j] = j;
        }
    }

    public Permutation(int[] nArray) {
        if (!this.isPermutation(nArray)) {
            throw new IllegalArgumentException("array is not a permutation vector");
        }
        this.perm = IntUtils.clone(nArray);
    }

    public Permutation(byte[] byArray) {
        int n;
        if (byArray.length <= 4) {
            throw new IllegalArgumentException("invalid encoding");
        }
        int n2 = LittleEndianConversions.OS2IP(byArray, 0);
        if (byArray.length != 4 + n2 * (n = IntegerFunctions.ceilLog256(n2 - 1))) {
            throw new IllegalArgumentException("invalid encoding");
        }
        this.perm = new int[n2];
        for (int j = 0; j < n2; ++j) {
            this.perm[j] = LittleEndianConversions.OS2IP(byArray, 4 + j * n, n);
        }
        if (!this.isPermutation(this.perm)) {
            throw new IllegalArgumentException("invalid encoding");
        }
    }

    public Permutation(int n, SecureRandom secureRandom) {
        int n2;
        if (n <= 0) {
            throw new IllegalArgumentException("invalid length");
        }
        this.perm = new int[n];
        int[] nArray = new int[n];
        for (n2 = 0; n2 < n; ++n2) {
            nArray[n2] = n2;
        }
        n2 = n;
        for (int j = 0; j < n; ++j) {
            int n3 = RandUtils.nextInt(secureRandom, n2);
            this.perm[j] = nArray[n3];
            nArray[n3] = nArray[--n2];
        }
    }

    public byte[] getEncoded() {
        int n = this.perm.length;
        int n2 = IntegerFunctions.ceilLog256(n - 1);
        byte[] byArray = new byte[4 + n * n2];
        LittleEndianConversions.I2OSP(n, byArray, 0);
        for (int j = 0; j < n; ++j) {
            LittleEndianConversions.I2OSP(this.perm[j], byArray, 4 + j * n2, n2);
        }
        return byArray;
    }

    public int[] getVector() {
        return IntUtils.clone(this.perm);
    }

    public Permutation computeInverse() {
        Permutation permutation = new Permutation(this.perm.length);
        for (int j = this.perm.length - 1; j >= 0; --j) {
            permutation.perm[this.perm[j]] = j;
        }
        return permutation;
    }

    public Permutation rightMultiply(Permutation permutation) {
        if (permutation.perm.length != this.perm.length) {
            throw new IllegalArgumentException("length mismatch");
        }
        Permutation permutation2 = new Permutation(this.perm.length);
        for (int j = this.perm.length - 1; j >= 0; --j) {
            permutation2.perm[j] = this.perm[permutation.perm[j]];
        }
        return permutation2;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Permutation)) {
            return false;
        }
        Permutation permutation = (Permutation)object;
        return IntUtils.equals(this.perm, permutation.perm);
    }

    public String toString() {
        String string = "[" + this.perm[0];
        for (int j = 1; j < this.perm.length; ++j) {
            string = string + ", " + this.perm[j];
        }
        string = string + "]";
        return string;
    }

    public int hashCode() {
        return Arrays.hashCode(this.perm);
    }

    private boolean isPermutation(int[] nArray) {
        int n = nArray.length;
        boolean[] blArray = new boolean[n];
        for (int j = 0; j < n; ++j) {
            if (nArray[j] < 0 || nArray[j] >= n || blArray[nArray[j]]) {
                return false;
            }
            blArray[nArray[j]] = true;
        }
        return true;
    }
}

