/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.internal.nio.Bits;
import java.nio.ByteBuffer;

public class ClientMessageWriter {
    private transient ClientMessage.Frame currentFrame;
    private transient int writeOffset = -1;

    public boolean writeTo(ByteBuffer dst, ClientMessage clientMessage) {
        if (this.currentFrame == null) {
            this.currentFrame = clientMessage.getStartFrame();
        }
        while (true) {
            boolean isLastFrame;
            boolean bl = isLastFrame = this.currentFrame.next == null;
            if (!this.writeFrame(dst, this.currentFrame, isLastFrame)) break;
            this.writeOffset = -1;
            if (isLastFrame) {
                this.currentFrame = null;
                return true;
            }
            this.currentFrame = this.currentFrame.next;
        }
        return false;
    }

    private boolean writeFrame(ByteBuffer dst, ClientMessage.Frame frame, boolean isLastFrame) {
        boolean done;
        int bytesWrite;
        int bytesWritable = dst.remaining();
        int frameContentLength = frame.content.length;
        if (this.writeOffset == -1) {
            if (bytesWritable >= 6) {
                Bits.writeIntL(dst, dst.position(), frameContentLength + 6);
                dst.position(dst.position() + 4);
                if (isLastFrame) {
                    Bits.writeShortL(dst, dst.position(), (short)(frame.flags | 0x2000));
                } else {
                    Bits.writeShortL(dst, dst.position(), (short)frame.flags);
                }
                dst.position(dst.position() + 2);
                this.writeOffset = 0;
            } else {
                return false;
            }
        }
        bytesWritable = dst.remaining();
        if (frameContentLength == 0) {
            return true;
        }
        int bytesNeeded = frameContentLength - this.writeOffset;
        if (bytesWritable >= bytesNeeded) {
            bytesWrite = bytesNeeded;
            done = true;
        } else {
            bytesWrite = bytesWritable;
            done = false;
        }
        dst.put(frame.content, this.writeOffset, bytesWrite);
        this.writeOffset += bytesWrite;
        return done;
    }
}

