/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.nearcache.impl.record;

import com.hazelcast.internal.nearcache.NearCacheRecord;
import com.hazelcast.internal.util.TimeStripUtil;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;

public abstract class AbstractNearCacheRecord<V>
implements NearCacheRecord<V> {
    public static final int NUMBER_OF_LONG_FIELD_TYPES = 2;
    public static final int NUMBER_OF_INTEGER_FIELD_TYPES = 5;
    public static final int NUMBER_OF_BOOLEAN_FIELD_TYPES = 1;
    private static final AtomicIntegerFieldUpdater<AbstractNearCacheRecord> HITS = AtomicIntegerFieldUpdater.newUpdater(AbstractNearCacheRecord.class, "hits");
    private static final AtomicLongFieldUpdater<AbstractNearCacheRecord> RECORD_STATE = AtomicLongFieldUpdater.newUpdater(AbstractNearCacheRecord.class, "reservationId");
    protected int creationTime;
    protected volatile V value;
    protected volatile UUID uuid;
    protected volatile boolean cachedAsNull;
    protected volatile int hits;
    protected volatile int partitionId;
    protected volatile int lastAccessTime = -1;
    protected volatile int expirationTime;
    protected volatile long invalidationSequence;
    protected volatile long reservationId = -2L;

    public AbstractNearCacheRecord(V value, long creationTime, long expirationTime) {
        this.value = value;
        this.creationTime = TimeStripUtil.stripBaseTime(creationTime);
        this.expirationTime = TimeStripUtil.stripBaseTime(expirationTime);
    }

    @Override
    public boolean isCachedAsNull() {
        return this.cachedAsNull;
    }

    @Override
    public void setCachedAsNull(boolean valueCachedAsNull) {
        this.cachedAsNull = valueCachedAsNull;
    }

    @Override
    public V getValue() {
        return this.value;
    }

    @Override
    public void setValue(V value) {
        this.value = value;
    }

    @Override
    public long getExpirationTime() {
        return TimeStripUtil.recomputeWithBaseTime(this.expirationTime);
    }

    @Override
    public void setExpirationTime(long expirationTime) {
        this.expirationTime = TimeStripUtil.stripBaseTime(expirationTime);
    }

    @Override
    public long getCreationTime() {
        return TimeStripUtil.recomputeWithBaseTime(this.creationTime);
    }

    @Override
    public void setCreationTime(long creationTime) {
        this.creationTime = TimeStripUtil.stripBaseTime(creationTime);
    }

    @Override
    public long getLastAccessTime() {
        return TimeStripUtil.recomputeWithBaseTime(this.lastAccessTime);
    }

    @Override
    public void setLastAccessTime(long lastAccessTime) {
        this.lastAccessTime = TimeStripUtil.stripBaseTime(lastAccessTime);
    }

    @Override
    public long getHits() {
        return this.hits;
    }

    @Override
    public void setHits(int hits) {
        HITS.set(this, hits);
    }

    @Override
    public void incrementHits() {
        HITS.addAndGet(this, 1);
    }

    @Override
    public long getReservationId() {
        return this.reservationId;
    }

    @Override
    public void setReservationId(long reservationId) {
        RECORD_STATE.set(this, reservationId);
    }

    @Override
    public int getPartitionId() {
        return this.partitionId;
    }

    @Override
    public void setPartitionId(int partitionId) {
        this.partitionId = partitionId;
    }

    @Override
    public long getInvalidationSequence() {
        return this.invalidationSequence;
    }

    @Override
    public void setInvalidationSequence(long sequence) {
        this.invalidationSequence = sequence;
    }

    @Override
    public void setUuid(UUID uuid) {
        this.uuid = uuid;
    }

    @Override
    public boolean hasSameUuid(UUID thatUuid) {
        return this.uuid != null && thatUuid != null && this.uuid.equals(thatUuid);
    }

    public String toString() {
        return "AbstractNearCacheRecord{creationTime=" + this.creationTime + ", value=" + this.value + ", uuid=" + this.uuid + ", cachedAsNull=" + this.cachedAsNull + ", hits=" + this.hits + ", partitionId=" + this.partitionId + ", lastAccessTime=" + this.lastAccessTime + ", expirationTime=" + this.expirationTime + ", invalidationSequence=" + this.invalidationSequence + ", reservationId=" + this.reservationId + "}";
    }
}

