/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.connector;

import com.hazelcast.core.ManagedContext;
import com.hazelcast.function.BiConsumerEx;
import com.hazelcast.function.FunctionEx;
import com.hazelcast.jet.Traverser;
import com.hazelcast.jet.core.AbstractProcessor;
import com.hazelcast.jet.core.BroadcastKey;
import com.hazelcast.jet.core.EventTimeMapper;
import com.hazelcast.jet.core.EventTimePolicy;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.impl.JetEvent;
import com.hazelcast.security.PermissionsUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ConvenientSourceP<C, T, S>
extends AbstractProcessor {
    private final Function<? super Processor.Context, ? extends C> createFn;
    private final BiConsumer<? super C, ? super SourceBufferConsumerSide<?>> fillBufferFn;
    private final FunctionEx<? super C, ? extends S> createSnapshotFn;
    private final BiConsumerEx<? super C, ? super List<S>> restoreSnapshotFn;
    private final Consumer<? super C> destroyFn;
    private final SourceBufferConsumerSide<?> buffer;
    private final EventTimeMapper<T> eventTimeMapper;
    private BroadcastKey<Integer> snapshotKey;
    private boolean initialized;
    private C ctx;
    private Traverser<?> traverser;
    private S pendingState;
    private List<S> restoredStates;

    public ConvenientSourceP(@Nonnull Function<? super Processor.Context, ? extends C> createFn, @Nonnull BiConsumer<? super C, ? super SourceBufferConsumerSide<?>> fillBufferFn, @Nonnull FunctionEx<? super C, ? extends S> createSnapshotFn, @Nonnull BiConsumerEx<? super C, ? super List<S>> restoreSnapshotFn, @Nonnull Consumer<? super C> destroyFn, @Nonnull SourceBufferConsumerSide<?> buffer, @Nullable EventTimePolicy<? super T> eventTimePolicy) {
        this.createFn = createFn;
        this.fillBufferFn = fillBufferFn;
        this.createSnapshotFn = createSnapshotFn;
        this.restoreSnapshotFn = restoreSnapshotFn;
        this.destroyFn = destroyFn;
        this.buffer = buffer;
        if (eventTimePolicy != null) {
            this.eventTimeMapper = new EventTimeMapper<T>(eventTimePolicy);
            this.eventTimeMapper.addPartitions(1);
        } else {
            this.eventTimeMapper = null;
        }
    }

    @Override
    public boolean isCooperative() {
        return false;
    }

    @Override
    protected void init(@Nonnull Processor.Context context) {
        PermissionsUtil.checkPermission(this.createSnapshotFn, context);
        ManagedContext managedContext = context.managedContext();
        this.ctx = managedContext.initialize(this.createFn.apply(context));
        this.snapshotKey = BroadcastKey.broadcastKey(context.globalProcessorIndex());
        this.initialized = true;
    }

    @Override
    public boolean complete() {
        boolean bufferEmitted;
        if (this.traverser == null) {
            this.fillBufferFn.accept(this.ctx, this.buffer);
            Traverser<Object> traverser = this.eventTimeMapper == null ? this.buffer.traverse() : (this.traverser = this.buffer.isEmpty() ? this.eventTimeMapper.flatMapIdle() : this.buffer.traverse().flatMap(t -> {
                JetEvent je = (JetEvent)t;
                return this.eventTimeMapper.flatMapEvent(je.payload(), 0, je.timestamp());
            }));
        }
        if (bufferEmitted = this.emitFromTraverser(this.traverser)) {
            this.traverser = null;
        }
        return bufferEmitted && this.buffer.isClosed();
    }

    @Override
    public boolean saveToSnapshot() {
        if (this.traverser != null && !this.emitFromTraverser(this.traverser)) {
            return false;
        }
        if (this.buffer.isClosed()) {
            return true;
        }
        this.traverser = null;
        if (this.pendingState == null) {
            this.pendingState = this.createSnapshotFn.apply(this.ctx);
        }
        if (this.pendingState == null || this.tryEmitToSnapshot(this.snapshotKey, this.pendingState)) {
            this.pendingState = null;
            return true;
        }
        return false;
    }

    @Override
    protected void restoreFromSnapshot(@Nonnull Object key, @Nonnull Object value) {
        if (this.restoredStates == null) {
            this.restoredStates = new ArrayList<S>();
        }
        this.restoredStates.add(value);
    }

    @Override
    public boolean finishSnapshotRestore() {
        if (this.restoredStates != null) {
            this.restoreSnapshotFn.accept(this.ctx, this.restoredStates);
        }
        this.restoredStates = null;
        return true;
    }

    @Override
    public void close() {
        if (this.initialized) {
            this.destroyFn.accept(this.ctx);
        }
    }

    public static interface SourceBufferConsumerSide<T> {
        public Traverser<T> traverse();

        public boolean isEmpty();

        public boolean isClosed();
    }
}

