/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.pipeline.file;

import com.hazelcast.jet.JetException;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.pipeline.BatchSource;
import com.hazelcast.jet.pipeline.Sources;
import com.hazelcast.jet.pipeline.file.FileFormat;
import com.hazelcast.jet.pipeline.file.WildcardMatcher;
import com.hazelcast.jet.pipeline.file.impl.FileSourceConfiguration;
import com.hazelcast.jet.pipeline.file.impl.FileSourceFactory;
import com.hazelcast.jet.pipeline.file.impl.LocalFileSourceFactory;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import javax.annotation.Nonnull;

public class FileSourceBuilder<T> {
    private static final List<String> HADOOP_PREFIXES = List.of("s3a://", "hdfs://", "wasbs://", "adl://", "abfs://", "gs://");
    private final Map<String, String> options = new HashMap<String, String>();
    private final String path;
    private String glob = "*";
    private FileFormat<T> format;
    private boolean useHadoop;
    private boolean sharedFileSystem;
    private boolean ignoreFileNotFound;

    FileSourceBuilder(@Nonnull String path) {
        this.path = Objects.requireNonNull(path, "path must not be null");
        if (WildcardMatcher.hasWildcard(path)) {
            throw new IllegalArgumentException("Provided path must not contain any wildcard characters, path: " + path);
        }
        if (!FileSourceBuilder.hasHadoopPrefix(path) && !Paths.get(path, new String[0]).isAbsolute()) {
            throw new IllegalArgumentException("Provided path must be absolute, path: " + path);
        }
    }

    public FileSourceBuilder<T> glob(@Nonnull String glob) {
        this.glob = Objects.requireNonNull(glob, "glob must not be null");
        return this;
    }

    @Nonnull
    public <T_NEW> FileSourceBuilder<T_NEW> format(@Nonnull FileFormat<T_NEW> fileFormat) {
        FileSourceBuilder newThis = this;
        newThis.format = fileFormat;
        return newThis;
    }

    @Nonnull
    public FileSourceBuilder<T> useHadoopForLocalFiles(boolean useHadoop) {
        this.useHadoop = useHadoop;
        return this;
    }

    @Nonnull
    public FileSourceBuilder<T> sharedFileSystem(boolean sharedFileSystem) {
        this.sharedFileSystem = sharedFileSystem;
        return this;
    }

    @Nonnull
    public FileSourceBuilder<T> ignoreFileNotFound(boolean ignoreFileNotFound) {
        this.ignoreFileNotFound = ignoreFileNotFound;
        return this;
    }

    @Nonnull
    public FileSourceBuilder<T> option(String key, String value) {
        Objects.requireNonNull(key, "key must not be null");
        Objects.requireNonNull(value, "value must not be null");
        this.options.put(key, value);
        return this;
    }

    @Nonnull
    public BatchSource<T> build() {
        ProcessorMetaSupplier metaSupplier = this.buildMetaSupplier();
        return Sources.batchFromProcessor("files(path=" + this.path + ", glob=" + this.glob + ", hadoop=" + this.shouldUseHadoop(), metaSupplier);
    }

    @Nonnull
    public ProcessorMetaSupplier buildMetaSupplier() {
        if (this.path == null) {
            throw new IllegalStateException("Parameter 'path' is required");
        }
        if (this.format == null) {
            throw new IllegalStateException("Parameter 'format' is required");
        }
        FileSourceConfiguration<T> fsc = new FileSourceConfiguration<T>(this.path, this.glob, this.format, this.sharedFileSystem, this.ignoreFileNotFound, this.options);
        if (this.shouldUseHadoop()) {
            ServiceLoader<FileSourceFactory> loader = ServiceLoader.load(FileSourceFactory.class);
            Iterator<FileSourceFactory> iterator = loader.iterator();
            if (!iterator.hasNext()) {
                throw new JetException("No suitable FileSourceFactory found. Do you have Jet's Hadoop module on classpath?");
            }
            FileSourceFactory fileSourceFactory = iterator.next();
            if (iterator.hasNext()) {
                throw new JetException("Multiple FileSourceFactory implementations found");
            }
            return fileSourceFactory.create(fsc);
        }
        return new LocalFileSourceFactory().create(fsc);
    }

    private boolean shouldUseHadoop() {
        return this.useHadoop || FileSourceBuilder.hasHadoopPrefix(this.path);
    }

    public static boolean hasHadoopPrefix(String path) {
        return HADOOP_PREFIXES.stream().anyMatch(path::startsWith);
    }
}

