/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.vector.impl;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.vector.VectorDocument;
import com.hazelcast.vector.VectorValues;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nonnull;

public class VectorDocumentImpl<V>
implements VectorDocument<V>,
IdentifiedDataSerializable {
    private V userValue;
    private VectorValues vectorValues;

    public VectorDocumentImpl() {
    }

    public VectorDocumentImpl(@Nonnull V userValue, @Nonnull VectorValues vectorValues) {
        this.userValue = Objects.requireNonNull(userValue, "userValue cannot be null");
        this.vectorValues = Objects.requireNonNull(vectorValues, "vectorValues cannot be null");
    }

    @Override
    @Nonnull
    public V getValue() {
        return this.userValue;
    }

    @Override
    @Nonnull
    public VectorValues getVectors() {
        return this.vectorValues;
    }

    public VectorDocument<V> value(@Nonnull V userValue) {
        this.userValue = Objects.requireNonNull(userValue, "userValue cannot be null");
        return this;
    }

    public VectorDocument<V> vectorValues(@Nonnull VectorValues vectorValues) {
        this.vectorValues = Objects.requireNonNull(vectorValues, "vectorValues cannot be null");
        return this;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeObject(this.userValue);
        out.writeObject(this.vectorValues);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.userValue = in.readObject();
        this.vectorValues = (VectorValues)in.readObject();
    }

    @Override
    public int getFactoryId() {
        return -100;
    }

    @Override
    public int getClassId() {
        return 1;
    }

    public String toString() {
        return "VectorDocumentImpl{userValue=" + this.userValue + ", vectorValues=" + this.vectorValues + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VectorDocumentImpl that = (VectorDocumentImpl)o;
        return Objects.equals(this.userValue, that.userValue) && Objects.equals(this.vectorValues, that.vectorValues);
    }

    public int hashCode() {
        return Objects.hash(this.userValue, this.vectorValues);
    }
}

