/*
 * Decompiled with CFR 0.152.
 */
package net.messagevortex;

import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.messagevortex.Config;
import net.messagevortex.MessageVortex;
import net.messagevortex.MessageVortexLogger;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import picocli.CommandLine;

public class Version
implements CommandLine.IVersionProvider {
    private static final Logger LOGGER = MessageVortexLogger.getLogger(new Throwable().getStackTrace()[0].getClassName());
    private static String intVersion = null;
    private static int MAJOR = -1;
    private static int MINOR = -1;
    private static int REVISION = -1;
    private static final String GIT_BUILD = "$Id: c8eea54fdacbce7fcb86c4b9bb969451e097c274 $";
    private static final String BUILD = "$Id: c8eea54fdacbce7fcb86c4b9bb969451e097c274 $".substring(5, "$Id: c8eea54fdacbce7fcb86c4b9bb969451e097c274 $".length() - 2);
    private static String VERSION_STRING = null;
    private static String BUILDVER = null;

    private Version() {
    }

    public static String getBuild() {
        Version.init();
        return BUILDVER;
    }

    public static String getStringVersion() {
        Version.init();
        return intVersion;
    }

    public String[] getVersion() {
        Version.init();
        return new String[]{VERSION_STRING};
    }

    private static synchronized void init() {
        if (intVersion == null) {
            Class<MessageVortex> main;
            Package pkg;
            String version = null;
            try (InputStream is = Config.class.getResourceAsStream("/META-INF/messageVortex.properties");){
                Properties p = new Properties();
                if (is != null) {
                    p.load(is);
                    version = p.getProperty("application.version", "");
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "unable to get version number from property file", e);
            }
            if ((version == null || "${project.version}".equals(version)) && (pkg = (main = MessageVortex.class).getPackage()) != null && (version = pkg.getImplementationVersion()) == null && (version = pkg.getSpecificationVersion()) == null) {
                try {
                    LOGGER.log(Level.INFO, "reading version information directly from POM");
                    MavenXpp3Reader reader = new MavenXpp3Reader();
                    Model model = reader.read((Reader)new FileReader("pom.xml"));
                    version = model.getVersion();
                }
                catch (IOException | XmlPullParserException e) {
                    LOGGER.log(Level.WARNING, "Exhausted all possibilities to find pom version (PWD: " + System.getProperty("user.dir") + ")", e);
                }
            }
            if (version != null) {
                intVersion = version;
                Pattern versionPat = Pattern.compile("^\\s*([0-9]+)\\.([0-9]+)\\.([0-9]+)\\s*$");
                Matcher m = versionPat.matcher(intVersion);
                if (m.matches()) {
                    MAJOR = Integer.parseInt(m.group(1));
                    MINOR = Integer.parseInt(m.group(2));
                    REVISION = Integer.parseInt(m.group(3));
                    VERSION_STRING = MAJOR + "." + MINOR + "." + REVISION;
                    BUILDVER = VERSION_STRING + " (" + BUILD + ")";
                } else {
                    LOGGER.log(Level.SEVERE, "Version " + intVersion + " does not match the required regular expression");
                    LOGGER.log(Level.SEVERE, "If this happens while testing in IDE try to run 'mvn -DskipTests package'.");
                }
            } else {
                LOGGER.log(Level.SEVERE, "unable to get version number of application");
            }
        }
    }
}

