/*
 * Decompiled with CFR 0.152.
 */
package net.messagevortex.asn1;

import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import net.messagevortex.asn1.AbstractBlock;
import net.messagevortex.asn1.Dumpable;
import net.messagevortex.asn1.encryption.DumpType;
import net.messagevortex.asn1.encryption.Parameter;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;

public class AlgorithmParameter
extends AbstractBlock
implements Serializable,
Comparable<AlgorithmParameter>,
Dumpable {
    public static final long serialVersionUID = 100000000001L;
    private final Map<Integer, String> parameter = new ConcurrentSkipListMap<Integer, String>();

    public AlgorithmParameter() {
    }

    public AlgorithmParameter(ASN1Encodable ae) throws IOException {
        this();
        if (ae != null) {
            this.parse(ae);
        }
    }

    public AlgorithmParameter(AlgorithmParameter p) {
        this();
        for (Map.Entry<Integer, String> e : p.parameter.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    public final String put(String id, String value) {
        return this.put(Parameter.getByString(id).getId(), value);
    }

    public final String put(int id, String value) {
        if (value == null) {
            String ret = this.get(id);
            this.parameter.remove(id);
            return ret;
        }
        return this.parameter.put(id, value);
    }

    public final String put(Parameter parameter, String value) {
        assert (parameter != Parameter.KEYSIZE || this.get(parameter.getId()) == null || this.get(parameter.getId()).equals(value));
        return this.put(parameter.getId(), value);
    }

    public final String get(String id) {
        Parameter p = Parameter.getByString(id);
        if (p == null) {
            throw new IllegalArgumentException("got unknown parameter id to map (" + id + ")");
        }
        return this.get(p.getId());
    }

    public String get(Parameter p) {
        return this.get(p.getId());
    }

    public String get(int id) {
        return this.parameter.get(id);
    }

    @Override
    protected final void parse(ASN1Encodable ae) throws IOException {
        ASN1Sequence s1 = ASN1Sequence.getInstance((Object)ae);
        for (ASN1Encodable o : s1) {
            ASN1TaggedObject to = ASN1TaggedObject.getInstance((Object)o);
            Parameter p = Parameter.getById(to.getTagNo());
            if (p.isEncodable()) {
                this.parameter.put(to.getTagNo(), p.fromAsn1Object(to.getBaseObject()));
                continue;
            }
            throw new IOException("unknown der tagged object when parsing parameter (" + to.getTagNo() + ")");
        }
    }

    @Override
    public String dumpValueNotation(String prefix, DumpType dumpType) {
        StringBuilder sb = new StringBuilder();
        sb.append('{').append("\r\n");
        int i = 0;
        for (Map.Entry<Integer, String> e : this.parameter.entrySet()) {
            Parameter p = Parameter.getById(e.getKey());
            if (p == null || !p.isEncodable()) continue;
            if (i > 0) {
                sb.append(',').append("\r\n");
            }
            sb.append(prefix).append("  ").append(p).append(" \"").append(e.getValue()).append('\"');
            ++i;
        }
        sb.append(prefix).append("\r\n").append(prefix).append('}');
        return sb.toString();
    }

    @Override
    public ASN1Object toAsn1Object(DumpType dt) {
        ASN1EncodableVector v = new ASN1EncodableVector();
        for (Map.Entry<Integer, String> e : this.parameter.entrySet()) {
            Parameter p = Parameter.getById(e.getKey());
            if ((p == null || !p.isEncodable()) && dt != DumpType.INTERNAL) continue;
            v.add((ASN1Encodable)new DERTaggedObject(p.getId(), p.toAsn1Object(e.getValue())));
        }
        return new DERSequence(v);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        for (Map.Entry<Integer, String> e : this.parameter.entrySet()) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(Parameter.getById(e.getKey())).append("=\"").append(e.getValue()).append('\"');
            ++i;
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        return ((AlgorithmParameter)o).compareTo(this) == 0;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public int compareTo(AlgorithmParameter o) {
        return this.toString().compareTo(o.toString());
    }
}

