/*
 * Decompiled with CFR 0.152.
 */
package net.messagevortex.transport.imap;

import java.util.logging.Level;
import java.util.logging.Logger;
import net.messagevortex.MessageVortexLogger;
import net.messagevortex.transport.imap.ImapCommand;
import net.messagevortex.transport.imap.ImapConnection;
import net.messagevortex.transport.imap.ImapConnectionState;
import net.messagevortex.transport.imap.ImapException;
import net.messagevortex.transport.imap.ImapLine;

public class ImapCommandLogin
extends ImapCommand {
    private static final Logger LOGGER = MessageVortexLogger.getLogger(new Throwable().getStackTrace()[0].getClassName());

    private String getAuthToken(ImapLine line) throws ImapException {
        String userid = line.getAString();
        if (userid == null) {
            throw new ImapException(line, "error parsing command (getting userid)");
        }
        return userid;
    }

    @Override
    public String[] processCommand(ImapLine line) throws ImapException {
        String userid = this.getAuthToken(line);
        if (line.skipWhitespace(1) != 1) {
            throw new ImapException(line, "error parsing command (skipping to password)");
        }
        String password = this.getAuthToken(line);
        line.skipWhitespace(-1);
        if (!line.skipLineEnd()) {
            throw new ImapException(line, "error parsing command");
        }
        String[] reply = null;
        if (line.getConnection() == null) {
            LOGGER.log(Level.SEVERE, "no connection found while calling login");
            reply = new String[]{line.getTag() + " BAD server configuration error\r\n"};
        } else if (!line.getConnection().isTls()) {
            LOGGER.log(Level.SEVERE, "no TLS but logging in with username and password");
            reply = new String[]{line.getTag() + " BAD authentication with username and password refused due current security strength\r\n"};
        } else if (line.getConnection().getAuth() == null) {
            LOGGER.log(Level.SEVERE, "no Authenticator found while calling login (1)");
            reply = new String[]{line.getTag() + " BAD server configuration error\r\n"};
        } else if (line.getConnection().getAuth().login(userid, password)) {
            line.getConnection().setImapState(ImapConnectionState.CONNECTION_AUTHENTICATED);
            reply = new String[]{line.getTag() + " OK LOGIN completed\r\n"};
        } else {
            reply = new String[]{line.getTag() + " NO bad username or password\r\n"};
        }
        return reply;
    }

    public String[] getCapabilities() {
        return this.getCapabilities(null);
    }

    @Override
    public String[] getCapabilities(ImapConnection ic) {
        if (ic != null && ic.isTls()) {
            return new String[]{"LOGIN"};
        }
        return new String[]{"LOGINDISABLED"};
    }

    @Override
    public String[] getCommandIdentifier() {
        return new String[]{"LOGIN"};
    }
}

